/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection.enums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ISubr;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispCollections;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.collection.enums.EnumTopologyException;
import net.morilib.lisp.collection.hash.LispHash;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.topology.AbstractLispFiniteTopology;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;
import net.morilib.util.bit.BitSet2;
import net.morilib.util.bit.BitSet2Class;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;
import net.morilib.util.primitive.iterator.IntegerIterator;

public class LispEnumSetClass
extends Datum2
implements ISubr {
    private OneToOneSet<Integer, Datum> map;
    private Collection<Tplg> topology;
    private BitSet2Class bscls;
    private static final Keyword POWER = Keyword.getKeyword("power");

    LispEnumSetClass(Collection<Datum> topology, Collection<Datum> data, LispMessage mesg) throws EnumTopologyException {
        this.setelems(data);
        this.bscls = new BitSet2Class(0, data.size());
        if (topology == null) {
            topology = null;
        } else {
            this.settops(topology, mesg);
        }
    }

    private BitSet2 tobit(ConsIterator t, Datum b, LispMessage mesg) {
        BitSet2 bs = this.bscls.newInstance();
        while (t.hasNext()) {
            Datum d = t.next();
            if (!this.map.containsValue(d)) continue;
            bs.add((Integer)this.map.getKey(d));
        }
        SubrUtils.checkProper(t, b, mesg);
        return bs;
    }

    private void setelems(Collection<Datum> t) {
        int i = 0;
        this.map = new HashOneToOneSet<Integer, Datum>();
        for (Datum d : t) {
            this.map.put(i++, d);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tplg settops1(Datum d, LispMessage mesg) throws EnumTopologyException {
        Tplg tp = new Tplg();
        ConsIterator itr = new ConsIterator(d);
        if (!itr.hasNext()) {
            Datum f = itr.getTerminal();
            tp.tplg = this.bscls.newInstance();
            tp.mask = this.bscls.newInstance();
            if (!this.map.containsValue(f)) throw new EnumTopologyException("err.collection.enumset.notelement", f);
            tp.tplg.add((Integer)this.map.getKey(f));
            return tp;
        } else {
            Datum e = itr.next();
            if (e.equals(POWER)) {
                tp.tplg = this.bscls.newInstance();
                tp.mask = this.tobit(itr, d, mesg);
                return tp;
            } else {
                tp = this.settops1(e, mesg);
                while (itr.hasNext()) {
                    Tplg sp = this.settops1(itr.next(), mesg);
                    tp.tplg = tp.tplg.join(sp.tplg);
                    tp.mask = tp.mask.join(sp.mask);
                }
                SubrUtils.checkProper(itr, d, mesg);
            }
        }
        return tp;
    }

    private void settops(Collection<Datum> t, LispMessage mesg) throws EnumTopologyException {
        this.topology = new ArrayList<Tplg>();
        for (Datum d : t) {
            Tplg s = this.settops1(d, mesg);
            s.mask = s.mask.complement();
            s.tplc = s.tplg.complement().meet(s.mask);
            this.topology.add(s);
        }
        for (Tplg x : this.topology) {
            Iterator<Tplg> iterator = this.topology.iterator();
            if (!iterator.hasNext()) continue;
            Tplg y = iterator.next();
            BitSet2 x2 = x.tplg.join(x.mask.complement());
            BitSet2 y2 = y.tplg.join(y.mask.complement());
            if (x2.containsAll(y.tplg) || y2.containsAll(x.tplg)) continue;
            throw new EnumTopologyException("err.collection.enumset.notelement", null);
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        BitSet2 bit = this.bscls.newInstance();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!this.map.containsValue(d)) continue;
            bit.add((Integer)this.map.getKey(d));
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return new LispEnumSet(this, bit);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<enum-set-class>");
    }

    public static class IsEnumSet
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispEnumSet);
        }
    }

    public static class LispEnumSet
    extends AbstractLispFiniteTopology
    implements LispSet {
        private BitSet2 bit;
        private LispEnumSetClass kls;

        private LispEnumSet(LispEnumSetClass kls, BitSet2 bit) {
            this.kls = kls;
            this.bit = bit;
        }

        @Override
        public boolean isNeighborhoodOf(Datum d) {
            if (this.kls.map.containsValue(d)) {
                return this.bit.contains((Integer)this.kls.map.getKey(d));
            }
            return false;
        }

        @Override
        public boolean isContained(ILispTopology t) {
            IntegerIterator itr = this.bit.iterator();
            while (itr.hasNext()) {
                if (t.isNeighborhoodOf((Datum)this.kls.map.getValue(itr.next()))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isIndependent(ILispTopology t) {
            IntegerIterator itr = this.bit.iterator();
            while (itr.hasNext()) {
                if (!t.isNeighborhoodOf((Datum)this.kls.map.getValue(itr.next()))) continue;
                return false;
            }
            return true;
        }

        @Override
        public ILispTopology unionTopology(ILispTopology t) {
            if (t instanceof LispEnumSet && this.kls.equals(((LispEnumSet)t).kls)) {
                return new LispEnumSet(this.kls, this.bit.join(((LispEnumSet)t).bit));
            }
            return super.unionTopology(t);
        }

        @Override
        public ILispTopology intersectionTopology(ILispTopology t) {
            if (t instanceof LispEnumSet && this.kls.equals(((LispEnumSet)t).kls)) {
                return new LispEnumSet(this.kls, this.bit.meet(((LispEnumSet)t).bit));
            }
            return super.intersectionTopology(t);
        }

        @Override
        public ILispTopology interior() {
            int m = -1;
            Tplg r = null;
            if (this.kls.topology == null) {
                return this;
            }
            if (this.bit.size() == 0 || this.bit.size() == this.kls.map.size()) {
                return this;
            }
            for (Tplg t : this.kls.topology) {
                int p = t.containso(this.bit);
                if (p <= m) continue;
                m = p;
                r = t;
            }
            if (r == null) {
                return new LispEnumSet(this.kls, this.kls.bscls.newInstance());
            }
            return new LispEnumSet(this.kls, this.bit.meet(r.tplg.join(r.mask.complement())));
        }

        @Override
        public ILispTopology closure() {
            int m = Integer.MAX_VALUE;
            Tplg r = null;
            if (this.kls.topology == null) {
                return this;
            }
            if (this.bit.size() == 0 || this.bit.size() == this.kls.map.size()) {
                return this;
            }
            for (Tplg t : this.kls.topology) {
                int p = t.containsc(this.bit);
                if (p >= m) continue;
                m = p;
                r = t;
            }
            if (r == null) {
                return new LispEnumSet(this.kls, this.kls.bscls.newInstance().complement());
            }
            return new LispEnumSet(this.kls, this.bit.join(r.tplc));
        }

        @Override
        public boolean isOpen() {
            if (this.kls.topology == null) {
                return true;
            }
            if (this.bit.size() == 0 || this.bit.size() == this.kls.map.size()) {
                return true;
            }
            for (Tplg t : this.kls.topology) {
                if (!t.eqvo(this.bit)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isClosed() {
            if (this.kls.topology == null) {
                return true;
            }
            if (this.bit.size() == 0 || this.bit.size() == this.kls.map.size()) {
                return true;
            }
            for (Tplg t : this.kls.topology) {
                if (!t.eqvc(this.bit)) continue;
                return true;
            }
            return false;
        }

        @Override
        public LispCardinality cardinality() {
            return LispCardinality.finiteValueOf(this.bit.size());
        }

        @Override
        public boolean isEmpty() {
            return this.bit.isEmpty();
        }

        @Override
        public boolean isUniverse() {
            return false;
        }

        @Override
        public Set<Datum> getJavaSet() {
            IntegerIterator itr = this.bit.iterator();
            HashSet<Datum> r = new HashSet<Datum>();
            while (itr.hasNext()) {
                r.add((Datum)this.kls.map.getValue(itr.next()));
            }
            return r;
        }

        @Override
        public Symbol getCollectionName() {
            return Symbol.getSymbol("enum-set");
        }

        @Override
        public Datum toList() {
            ConsListBuilder b = new ConsListBuilder();
            IntegerIterator i = this.bit.iterator();
            while (i.hasNext()) {
                b.append((Datum)this.kls.map.getValue(i.next()));
            }
            return b.get();
        }

        @Override
        public int count(Datum c2a) {
            IntegerIterator i = this.bit.iterator();
            int c = 0;
            while (i.hasNext()) {
                if (!((Datum)this.kls.map.getValue(i.next())).equals(c2a)) continue;
                ++c;
            }
            return c;
        }

        @Override
        public int size() {
            return this.bit.size();
        }

        @Override
        public LispEnumSet prototype() {
            return new LispEnumSet(this.kls, this.kls.bscls.newInstance());
        }

        @Override
        public Datum clear() {
            this.bit.clear();
            return this;
        }

        @Override
        public boolean equalTo(LispCollection col) {
            return LispCollections.equals(this, col);
        }

        @Override
        public boolean equalTo(LispCollection col, Procedure p, Environment env, LispMessage mesg) {
            return LispCollections.equalTo(this, col, p, env, mesg);
        }

        @Override
        public LispEnumSet duplicate() {
            return new LispEnumSet(this.kls, new BitSet2(this.bit));
        }

        @Override
        public boolean contains(Datum d) {
            return this.isNeighborhoodOf(d);
        }

        @Override
        public Iterator<Datum> iterator() {
            final IntegerIterator i = this.bit.iterator();
            return new Iterator<Datum>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public Datum next() {
                    return (Datum)LispEnumSet.this.kls.map.getValue(i.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public LispSet add(LispSet y) {
            return this.union(y);
        }

        @Override
        public LispSet sub(LispSet y) {
            return this.difference(y);
        }

        @Override
        public LispSet uminus() {
            return this.prototype();
        }

        @Override
        public LispSet mul(LispSet y) {
            return this.intersection(y);
        }

        @Override
        public Procedure equivalence() {
            return LispHash.EQV;
        }

        @Override
        public boolean equivalence(Datum a, Datum b) {
            return a.equals(b);
        }

        @Override
        public boolean subset(LispSet set) {
            for (Datum d : this) {
                if (set.contains(d)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Datum copyAdd(Datum d) {
            return this.duplicate().add(d);
        }

        @Override
        public Datum add(Datum d) {
            Integer p = (Integer)this.kls.map.getKey(d);
            if (p != null) {
                this.bit.add(p);
            }
            return this;
        }

        @Override
        public Datum copyDelete(Datum d) {
            return this.duplicate().delete(d);
        }

        @Override
        public Datum delete(Datum d) {
            Integer p = (Integer)this.kls.map.getKey(d);
            if (p != null) {
                this.bit.remove(p);
            }
            return this;
        }

        @Override
        public LispEnumSet union(LispSet s) {
            return this.duplicate().addAll(s);
        }

        @Override
        public LispEnumSet addAll(LispSet s) {
            for (Datum d : s) {
                this.add(d);
            }
            return this;
        }

        @Override
        public LispEnumSet intersection(LispSet s) {
            return this.duplicate().retainAll(s);
        }

        @Override
        public LispEnumSet retainAll(LispSet s) {
            for (Datum d : this.duplicate()) {
                if (s.contains(d)) continue;
                this.delete(d);
            }
            return this;
        }

        @Override
        public LispEnumSet difference(LispSet s) {
            return this.duplicate().removeAll(s);
        }

        @Override
        public LispEnumSet removeAll(LispSet s) {
            for (Datum d : s) {
                if (!this.contains(d)) continue;
                this.delete(d);
            }
            return this;
        }

        @Override
        public LispEnumSet symmetricDifference(LispSet s) {
            return this.duplicate().symmetricDifferenceModify(s);
        }

        @Override
        public LispEnumSet symmetricDifferenceModify(LispSet s) {
            for (Datum d : s) {
                if (this.contains(d)) {
                    this.delete(d);
                    continue;
                }
                this.add(d);
            }
            return this;
        }

        @Override
        public Datum copyAddFrom(LispBag b) {
            return this.duplicate().addFrom(b);
        }

        @Override
        public Datum addFrom(LispBag b) {
            for (Datum d : b) {
                this.add(d);
            }
            return this;
        }

        @Override
        public Datum copyDeleteFrom(LispBag b) {
            return this.duplicate().deleteFrom(b);
        }

        @Override
        public Datum deleteFrom(LispBag b) {
            for (Datum d : b) {
                if (!this.contains(d)) continue;
                this.delete(d);
            }
            return this;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            IntegerIterator itr = this.bit.iterator();
            String dlm = "";
            buf.append("#<enum-set (");
            while (itr.hasNext()) {
                int i = itr.next();
                buf.append(dlm);
                buf.append(LispUtils.print((Datum)this.kls.map.getValue(i)));
                dlm = " ";
            }
            buf.append(")>");
        }

        public int hashCode() {
            int r = 17;
            r = 37 * (r + this.kls.hashCode());
            r = 37 * (r + this.bit.hashCode());
            return r;
        }

        public boolean equals(Object o) {
            if (o instanceof LispEnumSet) {
                LispEnumSet s = (LispEnumSet)o;
                return this.kls.equals(s.kls) && this.bit.equals(s.bit);
            }
            return false;
        }
    }

    private static class Tplg {
        private BitSet2 tplg;
        private BitSet2 tplc;
        private BitSet2 mask;

        private Tplg() {
        }

        private int containso(BitSet2 b) {
            if (b.containsAllAnd(this.tplg, this.mask)) {
                return this.tplg.join(this.mask.complement()).meet(b).size();
            }
            return -1;
        }

        private boolean eqvo(BitSet2 b) {
            return this.tplg.equalsAnd(b, this.mask);
        }

        private int containsc(BitSet2 b) {
            if (this.tplc.containsAllAnd(b, this.mask)) {
                return this.tplc.join(b).size();
            }
            return Integer.MAX_VALUE;
        }

        private boolean eqvc(BitSet2 b) {
            return this.tplc.equalsAnd(b, this.mask);
        }
    }
}

