/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.diff;

import java.util.List;
import net.morilib.diff.Patch;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispPatch
extends UnaryArgs {
    Patch<Datum> patch;

    public LispPatch(Patch<Datum> patch) {
        this.patch = patch;
    }

    @Override
    public Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(c1a, mesg);
        try {
            List<Datum> r = this.patch.patch(l);
            return LispUtils.listToCons(r);
        }
        catch (RuntimeException e) {
            throw mesg.getError("err.diff.error.patch");
        }
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<patch>");
    }
}

