/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.iterator.LispIteratorDatum;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class MakeStringTokenizer
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        LispCharSet cs;
        final String s = SubrUtils.getString(c1a, mesg);
        final int[] p = new int[2];
        if (c2a instanceof LispCharSet) {
            cs = (LispCharSet)c2a;
        } else if (c2a instanceof LispString) {
            cs = new LispCharSet(c2a.getString());
        } else {
            throw mesg.getError("err.srfi14.require.charset", c2a);
        }
        return new LispIteratorDatum(){
            private String nxt = "";

            private int _g() {
                if (p[0] >= s.length()) {
                    return -1;
                }
                int n = p[0];
                p[0] = n + 1;
                char c1 = s.charAt(n);
                if (Character.isHighSurrogate(c1)) {
                    int n2 = p[0];
                    p[0] = n2 + 1;
                    return Character.toCodePoint(c1, s.charAt(n2));
                }
                return c1;
            }

            /*
             * Unable to fully structure code
             */
            private String _s() {
                b = new StringBuilder();
                if (p[1] >= 0) ** GOTO lbl7
                this.nxt = null;
                return null;
lbl-1000:
                // 1 sources

                {
                    b.appendCodePoint(p[1]);
lbl7:
                    // 2 sources

                    ** while (p[0] < s.length() && !cs.contains((int)(p[1] = this._g())))
                }
lbl8:
                // 1 sources

                if (p[0] >= s.length()) {
                    p[1] = -1;
                }
                while (p[0] < s.length() && cs.contains(p[1] = this._g())) {
                }
                if (this.nxt.equals("") && b.length() == 0 && p[0] >= s.length()) {
                    this.nxt = null;
                } else {
                    p[0] = p[0] - (p[1] < 0 ? 0 : (p[1] > 65535 ? 2 : 1));
                    this.nxt = b.toString();
                }
                return this.nxt;
            }

            @Override
            public boolean isTerminated() {
                if (this.nxt != null && this.nxt.equals("")) {
                    this._s();
                }
                return this.nxt == null;
            }

            @Override
            public ILispIterator next() {
                if (this.nxt.equals("")) {
                    this._s();
                }
                if (this.isTerminated()) {
                    throw new NoSuchElementException();
                }
                this._s();
                return this;
            }

            @Override
            public Datum getCurrentDatum() {
                if (this.nxt.equals("")) {
                    this._s();
                }
                if (this.isTerminated()) {
                    throw new NoSuchElementException();
                }
                return new LispString(this.nxt);
            }

            @Override
            public void toDisplayString(StringBuilder buf) {
                buf.append("#<string-tokenizer>");
            }
        };
    }
}

