/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.ldap;

import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import net.morilib.ldap.AttributeFilter;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.ldap.LispLDAPService;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class SelectLdapService
extends QuaternaryArgs {
    private Datum tolist(List<Map<String, List<String>>> rs) {
        ConsListBuilder r1 = new ConsListBuilder();
        for (Map<String, List<String>> e1 : rs) {
            ConsListBuilder r2 = new ConsListBuilder();
            for (Map.Entry<String, List<String>> e2 : e1.entrySet()) {
                ConsListBuilder r3 = new ConsListBuilder();
                for (String e3 : e2.getValue()) {
                    r3.append(new LispString(e3));
                }
                r2.append(new Cons(new LispString(e2.getKey()), r3.get()));
            }
            r1.append(r2.get());
        }
        return r1.get();
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispLDAPService)) {
            throw mesg.getError("err.ldap.require.ldapservice", c1a);
        }
        try {
            String dn = SubrUtils.getString(c2a, mesg);
            AttributeFilter fl = LispLDAPService.parseFilter(c3a, mesg);
            int sc = LispLDAPService.parseScope(c4a, mesg);
            List<Map<String, List<String>>> rs = ((LispLDAPService)c1a).manager.search(dn, fl, sc);
            return this.tolist(rs);
        }
        catch (NamingException e) {
            throw mesg.getError("err.ldap.error.naming");
        }
    }
}

