/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi013;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class StringTokenize
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        Datum d2 = Iterators.nextIf(itr, LispCharSet.GRAPHIC);
        int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
        int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
        if (b < 0 || b >= s.length()) {
            throw mesg.getError("err.string.outofrange", "" + b);
        }
        if (e < 0 || e > s.length()) {
            throw mesg.getError("err.string.outofrange", "" + e);
        }
        if (e < b) {
            throw mesg.getError("err.range.invalid");
        }
        if (d2 instanceof LispCharSet) {
            ConsListBuilder cb = new ConsListBuilder();
            StringBuilder bf = new StringBuilder();
            LispCharSet cs = (LispCharSet)d2;
            boolean stat = false;
            int i = b;
            while (i < e) {
                char ch = s.charAt(i);
                if (cs.contains(ch)) {
                    bf.append(ch);
                    stat = true;
                } else if (stat) {
                    cb.append(new LispString(bf.toString()));
                    bf = new StringBuilder();
                    stat = false;
                }
                ++i;
            }
            if (stat) {
                cb.append(new LispString(bf.toString()));
            }
            return cb.get();
        }
        throw mesg.getError("err.srfi14.require.charset", d2);
    }
}

