/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.angle;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.angle.LispAngleTrigonometric;
import net.morilib.lisp.math.angle.LispRadian;
import net.morilib.lisp.subr.SubrUtils;

public class AngleTan
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        LispReal x = SubrUtils.nextReal(itr, mesg, body);
        LispReal y = SubrUtils.nextReal(itr, null);
        if (y == null) {
            if (x.isRational() && x.signum() > 0) {
                return (Datum)((Object)LispAngleTrigonometric.tan(LispInteger.valueOf(x.getDenominator()), LispInteger.valueOf(x.getNumerator())));
            }
            return new LispRadian(Math.atan(x.doubleValue()));
        }
        if (!x.isExact() || !y.isExact() || x.signum() <= 0 || y.signum() <= 0) {
            return new LispRadian(Math.atan2(y.doubleValue(), x.doubleValue()));
        }
        return (Datum)((Object)LispAngleTrigonometric.tan(x, y));
    }
}

