/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.geometry.g3d;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.math.geometry.g3d.LispF64Vector3D;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class F64Vector3D
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        double x = SubrUtils.getDouble(c1a, mesg);
        double y = SubrUtils.getDouble(c2a, mesg);
        double z = SubrUtils.getDouble(c3a, mesg);
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw mesg.getError("err.math.require.notextreme", c1a);
        }
        if (Double.isInfinite(y) || Double.isNaN(y)) {
            throw mesg.getError("err.math.require.notextreme", c2a);
        }
        if (Double.isInfinite(z) || Double.isNaN(z)) {
            throw mesg.getError("err.math.require.notextreme", c3a);
        }
        return new LispF64Vector3D(x, y, z);
    }
}

