/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrices;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.math.polynomial1.Polynomial1Solver;

public class MatrixEigenvalues
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof ILispMatrix)) {
            throw mesg.getError("err.matrix.require.numbermatrix", c1a);
        }
        ILispMatrix m = (ILispMatrix)((Object)c1a);
        if (!m.isSquare()) {
            throw mesg.getError("err.matrix.require.squarematrix", c1a);
        }
        double[] cef = new double[m.rowSize() + 1];
        int i = 0;
        while (i < m.rowSize()) {
            LispNumber l = LispMatrices.determinantAllMinor(m, m.rowSize() - i);
            if (!l.isReal()) {
                throw mesg.getError("err.required.real", l);
            }
            cef[i] = l.getRealDouble();
            if ((m.rowSize() - i) % 2 == 1) {
                cef[i] = -cef[i];
            }
            ++i;
        }
        cef[m.rowSize()] = 1.0;
        double[] eig = Polynomial1Solver.solveAll(cef);
        ConsListBuilder b = new ConsListBuilder();
        i = 0;
        while (i < eig.length) {
            b.append(new LispDouble(eig[i]));
            ++i;
        }
        return b.get();
    }
}

