/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.polynomial1;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.polynomial1.ILispPolynomial1;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispPolynomial1
extends UnaryArgs
implements ILispPolynomial1,
Serializable {
    public static final LispPolynomial1 ZERO = new LispPolynomial1(new LispNumber[]{LispInteger.ZERO});
    private LispNumber[] coefficients;

    public LispPolynomial1(LispNumber[] coeff) {
        int d = this.degree(coeff);
        this.coefficients = new LispNumber[d + 1];
        int i = 0;
        while (i <= d) {
            this.coefficients[i] = coeff[i];
            ++i;
        }
    }

    public LispPolynomial1(ILispPolynomial1 poly) {
        this.coefficients = new LispNumber[poly.degree() + 1];
        int i = 0;
        while (i <= poly.degree()) {
            this.coefficients[i] = poly.coefficient(i);
            ++i;
        }
    }

    private int degree(LispNumber[] coeff) {
        int i = coeff.length - 1;
        while (i >= 0) {
            if (!coeff[i].isZero()) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static LispPolynomial1 newInstance(LispNumber ... coeffs) {
        LispNumber[] c2 = new LispNumber[coeffs.length];
        int i = 0;
        while (i < c2.length) {
            c2[c2.length - i - 1] = coeffs[i];
            ++i;
        }
        return new LispPolynomial1(c2);
    }

    public static LispPolynomial1 newInstance(double ... coeffs) {
        LispNumber[] c2 = new LispNumber[coeffs.length];
        int i = 0;
        while (i < c2.length) {
            c2[c2.length - i - 1] = new LispDouble(coeffs[i]);
            ++i;
        }
        return new LispPolynomial1(c2);
    }

    @Override
    public boolean isZero() {
        return this.coefficients.length == 0 || this.coefficients.length == 1 && this.coefficients[0].isZero();
    }

    @Override
    public LispNumber coefficient(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n >= this.coefficients.length) {
            return LispInteger.ZERO;
        }
        return this.coefficients[n];
    }

    @Override
    public int degree() {
        return this.coefficients.length - 1;
    }

    @Override
    public LispNumber substitute(LispNumber x) {
        LispNumber r = LispInteger.ZERO;
        int i = 0;
        while (i <= this.degree()) {
            r = ((LispNumber)r).add(this.coefficients[i].mul(x.pow(i)));
            ++i;
        }
        return r;
    }

    @Override
    public ILispPolynomial1 mul(LispNumber a) {
        LispPolynomial1 r = new LispPolynomial1(this);
        int i = 0;
        while (i <= r.degree()) {
            r.coefficients[i] = r.coefficients[i].mul(a);
            ++i;
        }
        return r;
    }

    @Override
    public ILispPolynomial1 div(LispNumber a) {
        LispPolynomial1 r = new LispPolynomial1(this);
        int i = 0;
        while (i <= r.degree()) {
            r.coefficients[i] = r.coefficients[i].div(a);
            ++i;
        }
        return r;
    }

    @Override
    public ILispPolynomial1 add(ILispPolynomial1 b) {
        LispNumber[] r = new LispNumber[Math.max(this.degree(), b.degree()) + 1];
        int i = 0;
        while (i < r.length) {
            r[i] = this.coefficient(i).add(b.coefficient(i));
            ++i;
        }
        return new LispPolynomial1(r);
    }

    @Override
    public ILispPolynomial1 sub(ILispPolynomial1 b) {
        LispNumber[] r = new LispNumber[Math.max(this.degree(), b.degree()) + 1];
        int i = 0;
        while (i < r.length) {
            r[i] = this.coefficient(i).sub(b.coefficient(i));
            ++i;
        }
        return new LispPolynomial1(r);
    }

    @Override
    public ILispPolynomial1 uminus() {
        LispPolynomial1 r = new LispPolynomial1(this);
        int i = 0;
        while (i <= r.degree()) {
            r.coefficients[i] = r.coefficients[i].uminus();
            ++i;
        }
        return r;
    }

    @Override
    public ILispPolynomial1 mul(ILispPolynomial1 b) {
        Object[] r = new LispNumber[this.degree() + b.degree() + 1];
        Arrays.fill(r, LispInteger.ZERO);
        int i = 0;
        while (i <= this.degree()) {
            int j = 0;
            while (j <= b.degree()) {
                r[i + j] = ((LispNumber)r[i + j]).add(this.coefficient(i).mul(b.coefficient(j)));
                ++j;
            }
            ++i;
        }
        return new LispPolynomial1((LispNumber[])r);
    }

    @Override
    public ILispPolynomial1[] divAndRemainder(ILispPolynomial1 b) {
        if (this.degree() < b.degree()) {
            return new LispPolynomial1[]{ZERO, this};
        }
        if (b.degree() == 0) {
            return new ILispPolynomial1[]{this.div(b.coefficient(0)), ZERO};
        }
        LispNumber[] d = new LispNumber[this.degree() - b.degree() + 1];
        LispNumber[] r = new LispNumber[this.degree() + 1];
        System.arraycopy(this.coefficients, 0, r, 0, r.length);
        int i = this.degree() - b.degree();
        while (i >= 0) {
            LispNumber x = r[i + b.degree()].div(b.coefficient(b.degree()));
            int j = i + b.degree();
            while (j >= i) {
                r[j] = r[j].sub(b.coefficient(j - i).mul(x));
                --j;
            }
            d[i] = x;
            --i;
        }
        return new ILispPolynomial1[]{new LispPolynomial1(d), new LispPolynomial1(r)};
    }

    @Override
    public ILispPolynomial1 differenciate() {
        if (this.coefficients.length > 0) {
            LispNumber[] r = new LispNumber[this.degree()];
            int i = 1;
            while (i <= r.length) {
                r[i - 1] = this.coefficients[i].mul(LispInteger.valueOf(i));
                ++i;
            }
            return new LispPolynomial1(r);
        }
        return ZERO;
    }

    @Override
    public ILispPolynomial1 integrate(LispNumber constant) {
        LispNumber[] r = new LispNumber[this.degree() + 2];
        r[0] = constant;
        int i = 0;
        while (i <= this.degree()) {
            r[i + 1] = this.coefficients[i].div(LispInteger.valueOf(i + 1));
            ++i;
        }
        return new LispPolynomial1(r);
    }

    @Override
    public LispReal integrate(LispReal a, LispReal b) {
        ILispPolynomial1 p = this.integrate(LispInteger.ZERO);
        return (LispReal)p.substitute(b).sub(p.substitute(a));
    }

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        return this.substitute(SubrUtils.getNumber(c1a, mesg));
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        String pl = "";
        int i = this.degree();
        while (i >= 0) {
            if (!this.coefficients[i].isZero()) {
                if (this.coefficients[i].getReal().signum() > 0) {
                    buf.append(pl);
                } else if (this.coefficients[i].getReal().signum() >= 0) {
                    if (this.coefficients[i].getImag().signum() > 0) {
                        buf.append(pl);
                    } else {
                        this.coefficients[i].getImag().signum();
                    }
                }
                if (!this.coefficients[i].isOne() && !this.coefficients[i].uminus().isOne() || i == 0) {
                    buf.append(LispUtils.print(this.coefficients[i]));
                }
                if (i > 1) {
                    buf.append("x^").append(i);
                } else if (i > 0) {
                    buf.append("x");
                }
                pl = "+";
            }
            --i;
        }
    }

    @Override
    public boolean isEqualTo(ILispPolynomial1 x) {
        if (this.degree() != x.degree()) {
            return false;
        }
        int i = 0;
        while (i <= this.degree()) {
            if (!this.coefficient(i).isEqualTo(x.coefficient(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.coefficients);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LispPolynomial1) {
            return Arrays.equals(this.coefficients, ((LispPolynomial1)o).coefficients);
        }
        return false;
    }
}

