/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.data;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.math.stat.data.LispStatisticsData;
import net.morilib.lisp.math.stat.xy.ILispXYData;
import net.morilib.math.stat.StatisticsUtils;

public class LispStatisticsXYData
extends Datum2
implements ILispXYData {
    private double[] dataX;
    private double[] dataY;
    private transient double[] reg = null;

    LispStatisticsXYData(double[] x, double[] y) {
        this.dataX = x;
        this.dataY = y;
    }

    public static LispStatisticsXYData newInstance(double[] x, double[] y) {
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new IllegalArgumentException();
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        double[] x1 = new double[x.length];
        double[] y1 = new double[y.length];
        System.arraycopy(x, 0, x1, 0, x.length);
        System.arraycopy(y, 0, y1, 0, y.length);
        return new LispStatisticsXYData(x1, y1);
    }

    @Override
    public double covariance() {
        return StatisticsUtils.covariance(this.dataX, this.dataY);
    }

    @Override
    public double correlationCoefficient() {
        return StatisticsUtils.correlation(this.dataX, this.dataY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] regression() {
        if (this.reg == null) {
            LispStatisticsXYData lispStatisticsXYData = this;
            synchronized (lispStatisticsXYData) {
                this.reg = StatisticsUtils.regression(this.dataX, this.dataY);
            }
        }
        return this.reg;
    }

    @Override
    public double[] errorTerm() {
        double[] r = new double[this.dataX.length];
        this.regression();
        int i = 0;
        while (i < this.dataX.length) {
            r[i] = this.dataY[i] - this.dataX[i] * this.reg[0] - this.reg[1];
            ++i;
        }
        return r;
    }

    @Override
    public LispStatisticsData errorTermData() {
        return new LispStatisticsData(this.errorTerm());
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<statistics-xy-data>");
    }
}

