/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.matrix;

import net.morilib.lisp.Datum;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.matrix.AbstractLispDatumMatrix;
import net.morilib.lisp.matrix.ILispDatumMatrix;

public abstract class AbstractLispArrayDatumMatrix
extends AbstractLispDatumMatrix
implements Cloneable {
    protected int rows;
    protected int columns;

    protected abstract Datum array(int var1);

    protected abstract void arrayset(int var1, Datum var2);

    protected abstract AbstractLispArrayDatumMatrix prototype();

    protected abstract AbstractLispArrayDatumMatrix prototype(int var1, int var2);

    @Override
    public abstract ILispDatumMatrix clone();

    protected abstract void arraycopy(int var1, Object var2, int var3, int var4);

    @Override
    public Datum get(int row, int column) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        return this.array(row * this.columns + column);
    }

    @Override
    public ILispVector getRowVector(int row) {
        Datum[] ra = new Datum[this.columns];
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        this.arraycopy(row * this.columns, ra, 0, this.columns);
        return new LispVector(ra);
    }

    @Override
    public ILispVector getColumnVector(int column) {
        Datum[] ra = new Datum[this.columns];
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.rows) {
            ra[i] = this.array(i * this.rows + column);
            ++i;
        }
        return new LispVector(ra);
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int columnSize() {
        return this.columns;
    }

    @Override
    public Datum get(int index) {
        return this.array(index);
    }

    @Override
    public int size() {
        return this.rows * this.columns;
    }

    @Override
    public void set(int row, int column, Datum x) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        this.arrayset(row * this.columns + column, x);
    }
}

