/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispDatagramSocket;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.net.SubrInetAddress;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispU8Vector;

public class ReceiveDatagramPacketU8
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int len;
        InetAddress adr;
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int prt = -1;
        if (!(c1a instanceof LispDatagramSocket)) {
            throw mesg.getError("err.net.require.datagramsocket", c1a);
        }
        if (c2a instanceof LispInetAddress) {
            adr = ((LispInetAddress)c2a).address;
            prt = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            len = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        } else if (c2a instanceof Cons) {
            adr = SubrInetAddress.listToInetAddress(c2a, mesg);
            prt = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            len = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        } else {
            adr = null;
            len = SubrUtils.getSmallInt(c2a, mesg);
        }
        try {
            if (len < 0) {
                throw mesg.getError("err.require.int.nonnegative", Integer.toString(len));
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            byte[] buf = new byte[len];
            DatagramPacket pkt = adr == null ? new DatagramPacket(buf, len) : new DatagramPacket(buf, len, adr, prt);
            ((LispDatagramSocket)c1a).socket.receive(pkt);
            return new LispU8Vector(buf);
        }
        catch (IOException e1) {
            throw mesg.getError("err.io");
        }
    }
}

