/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.net.LispDatagramSocket;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.net.SubrInetAddress;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispS8Vector;
import net.morilib.lisp.uvector.LispU8Vector;

public class SendDatagramPacket
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        byte[] buf;
        InetAddress adr;
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int prt = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        Datum c4a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (!(c1a instanceof LispDatagramSocket)) {
            throw mesg.getError("err.net.require.datagramsocket", c1a);
        }
        if (c2a instanceof LispInetAddress) {
            adr = ((LispInetAddress)c2a).address;
        } else if (c2a instanceof Cons) {
            adr = SubrInetAddress.listToInetAddress(c2a, mesg);
        } else {
            throw mesg.getError("err.net.require.address", c2a);
        }
        if (c4a instanceof LispS8Vector) {
            buf = ((LispS8Vector)c4a).toArray();
        } else if (c4a instanceof LispU8Vector) {
            buf = ((LispU8Vector)c4a).toArray();
        } else {
            throw mesg.getError("err.uvector.require.8", c4a);
        }
        try {
            int s = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, buf.length, mesg);
            if (s < 0 || s >= buf.length) {
                throw mesg.getError("err.range.invalid", Integer.toString(s));
            }
            if (e < 0 || e > buf.length) {
                throw mesg.getError("err.range.invalid", Integer.toString(e));
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            DatagramPacket pkt = new DatagramPacket(buf, s, e, adr, prt);
            ((LispDatagramSocket)c1a).socket.send(pkt);
        }
        catch (IOException e1) {
            throw mesg.getError("err.io");
        }
        return Undef.UNDEF;
    }
}

