/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.ftp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.net.ftp.LispFTPConnection;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.ftp.FTPActiveClient;

public class MakeFtpActiveConnection
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int port = 21;
        try {
            InetAddress saddr;
            InetAddress addr;
            String user;
            if (d2 instanceof LispSmallInt) {
                port = SubrUtils.getSmallInt(d2, mesg);
                user = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            } else {
                user = SubrUtils.getString(d2, mesg);
            }
            String pass = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            Datum d3 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d1 instanceof LispInetAddress) {
                addr = ((LispInetAddress)d1).getAddress();
            } else if (d1 instanceof LispString) {
                addr = InetAddress.getByName(d1.getString());
            } else {
                throw mesg.getError("err.net.require.hostnameoraddress", d1);
            }
            if (d3 instanceof LispInetAddress) {
                saddr = ((LispInetAddress)d1).getAddress();
            } else if (d3 instanceof LispString) {
                saddr = InetAddress.getByName(d1.getString());
            } else {
                throw mesg.getError("err.net.require.hostnameoraddress", d3);
            }
            if (saddr instanceof Inet4Address) {
                return new LispFTPConnection(new FTPActiveClient(addr, port, (Inet4Address)saddr, user, pass));
            }
            throw mesg.getError("err.net.require.address.v4", d3);
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

