/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.misc;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.syslog.SyslogFacility;
import net.morilib.net.syslog.SyslogLevel;
import net.morilib.net.syslog.SyslogP;

public class SyslogLogger
extends Subr {
    private static final String[] FACILITIES_STR = new String[]{"kernel-messages", "user-level-messages", "mail-system", "system-daemons", "security-messages", "messages-by-syslogd", "line-printer-subsystem", "network-news-subsystem", "uucp-subsystem", "clock-daemon", "security-messages2", "ftp-daemon", "ntp-subsystem", "log-audit", "log-alert", "clock-daemon2", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"};
    private static final SyslogFacility[] FACILITIES = new SyslogFacility[]{SyslogFacility.KERNEL_MESSAGES, SyslogFacility.USER_LEVEL_MESSAGES, SyslogFacility.MAIL_SYSTEM, SyslogFacility.SYSTEM_DAEMONS, SyslogFacility.SECURITY_MESSAGES, SyslogFacility.MESSAGES_BY_SYSLOGD, SyslogFacility.LINE_PRINTER_SUBSYSTEM, SyslogFacility.NETWORK_NEWS_SUBSYSTEM, SyslogFacility.UUCP_SUBSYSTEM, SyslogFacility.CLOCK_DAEMON, SyslogFacility.SECURITY_MESSAGES2, SyslogFacility.FTP_DAEMON, SyslogFacility.NTP_SUBSYSTEM, SyslogFacility.LOG_AUDIT, SyslogFacility.LOG_ALERT, SyslogFacility.CLOCK_DAEMON2, SyslogFacility.LOCAL0, SyslogFacility.LOCAL1, SyslogFacility.LOCAL2, SyslogFacility.LOCAL3, SyslogFacility.LOCAL4, SyslogFacility.LOCAL5, SyslogFacility.LOCAL6, SyslogFacility.LOCAL7};
    private static final String[] LEVELS_STR = new String[]{"emergency", "alert", "critical", "error", "warning", "notice", "info", "debug"};
    private static final SyslogLevel[] LEVELS = new SyslogLevel[]{SyslogLevel.EMERGENCY, SyslogLevel.ALERT, SyslogLevel.CRITICAL, SyslogLevel.ERROR, SyslogLevel.WARNING, SyslogLevel.NOTICE, SyslogLevel.INFORMATIONAL, SyslogLevel.DEBUG};

    private SyslogLevel getlevel(String lvl) {
        int i = 0;
        while (i < LEVELS_STR.length) {
            if (LEVELS_STR[i].equalsIgnoreCase(lvl)) {
                return LEVELS[i];
            }
            ++i;
        }
        return null;
    }

    private SyslogFacility getfacility(String fac) {
        int i = 0;
        while (i < FACILITIES_STR.length) {
            if (FACILITIES_STR[i].equalsIgnoreCase(fac)) {
                return FACILITIES[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        int port = 514;
        try {
            String host;
            String facs;
            InetAddress addr = SubrNetUtils.nextAddress(itr, body, mesg);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (d1 instanceof LispSmallInt) {
                port = SubrUtils.getSmallInt(d1, mesg);
                facs = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
            } else {
                facs = SubrUtils.getSymbolName(d1, mesg);
            }
            String lvls = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
            Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (d2 instanceof LispString) {
                host = SubrUtils.getString(d2, mesg);
            } else if (d2 instanceof LispInetAddress) {
                host = ((LispInetAddress)d2).getAddress().toString();
            } else {
                throw mesg.getError("err.net.require.hostnameoraddress", d2);
            }
            String lmsg = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            SyslogFacility fac = this.getfacility(facs);
            if (fac == null) {
                return LispBoolean.FALSE;
            }
            SyslogLevel lvl = this.getlevel(lvls);
            if (lvl == null) {
                return LispBoolean.FALSE;
            }
            return LispBoolean.getInstance(SyslogP.log(addr, port, lvl, fac, host, lmsg));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

