/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nio;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispEndianness;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Bytes;

public class LispBlob
extends Datum2 {
    private ByteBuffer buffer;
    private int start;

    LispBlob(ByteBuffer buf) {
        this.buffer = buf;
        this.start = buf.position();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<srfi-74 blob>");
    }

    public byte get(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        return this.buffer.get(i + this.start);
    }

    public int length() {
        return this.buffer.limit() - this.start;
    }

    public void put(int i, byte b) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        this.buffer.put(i + this.start, b);
    }

    public void order(LispEndianness.Endian c2a) {
        this.buffer.order(c2a.getByteOrder());
    }

    public short getShort(int k) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        return this.buffer.getShort(k + this.start);
    }

    public void putShort(int k, short number) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        this.buffer.putShort(k + this.start, number);
    }

    public int getInt(int k) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        return this.buffer.getInt(k + this.start);
    }

    public void putInt(int k, int number) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        this.buffer.putInt(k + this.start, number);
    }

    public long getLong(int k) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        return this.buffer.getLong(k + this.start);
    }

    public void putLong(int k, long number) {
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        this.buffer.putLong(k + this.start, number);
    }

    public BigInteger getBigInteger(int s, int k) {
        byte[] a = new byte[s];
        int p = this.buffer.position();
        if (k < 0) {
            throw new IndexOutOfBoundsException("" + k);
        }
        try {
            this.buffer.position(k + this.start);
            this.buffer.get(a, 0, s);
            BigInteger bigInteger = new BigInteger(a);
            return bigInteger;
        }
        finally {
            this.buffer.position(p);
        }
    }

    public void put(int s, int k, BigInteger x) {
        byte[] a2 = x.toByteArray();
        int p = this.buffer.position();
        try {
            this.buffer.position(k);
            if (s >= a2.length) {
                byte[] a = new byte[s];
                Arrays.fill(a, (byte)0);
                System.arraycopy(a2, 0, a, s - a2.length, a2.length);
                this.buffer.put(a, 0, s);
            } else {
                this.buffer.put(a2, a2.length - s, s);
            }
        }
        finally {
            this.buffer.position(p);
        }
    }

    public Datum toSintList(LispEndianness.Endian c2a, int s) {
        ConsListBuilder c = new ConsListBuilder();
        byte[] a = new byte[s];
        this.buffer.position(this.start);
        this.buffer.order(c2a.getByteOrder());
        while (this.buffer.remaining() >= s) {
            this.buffer.get(a);
            c.append(LispInteger.valueOf(new BigInteger(a)));
        }
        return c.get();
    }

    public Datum toOctetList() {
        ConsListBuilder b = new ConsListBuilder();
        int i = this.start;
        while (i < this.buffer.limit()) {
            b.append(LispInteger.valueOf(Bytes.ubyteToInt(this.buffer.get(i))));
            ++i;
        }
        return b.get();
    }

    public Datum toUintList(LispEndianness.Endian c2a, int s) {
        ConsListBuilder c = new ConsListBuilder();
        byte[] a = new byte[s + 1];
        a[0] = 0;
        this.buffer.position(0);
        this.buffer.order(c2a.getByteOrder());
        while (this.buffer.remaining() >= s) {
            this.buffer.get(a, 1, s);
            c.append(LispInteger.valueOf(new BigInteger(a)));
        }
        return c.get();
    }

    public BigInteger getUnsignedBigInteger(int s, int k) {
        byte[] a = new byte[s + 1];
        int p = this.buffer.position();
        try {
            this.buffer.position(k);
            this.buffer.get(a, 1, s);
            a[0] = 0;
            BigInteger bigInteger = new BigInteger(a);
            return bigInteger;
        }
        finally {
            this.buffer.position(p);
        }
    }

    public void putUnsigned(int s, int k, BigInteger x) {
        int p = this.buffer.position();
        byte[] a = x.toByteArray();
        try {
            this.buffer.position(k);
            if (a[0] == 0) {
                this.buffer.put(a, 1, s);
            } else {
                byte[] a2 = new byte[s];
                Arrays.fill(a, (byte)0);
                System.arraycopy(a2, 0, a, s - a2.length, a2.length);
                this.buffer.put(a, 0, s);
            }
        }
        finally {
            this.buffer.position(p);
        }
    }

    public boolean equalTo(LispBlob c2a) {
        ByteBuffer b1 = this.buffer;
        ByteBuffer b2 = c2a.buffer;
        int s2 = c2a.start;
        if (b1.limit() != b2.limit()) {
            return false;
        }
        int i = 0;
        while (i < this.length()) {
            if (b1.get(i + this.start) != b2.get(i + s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class MakeBlob
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            int s = SubrUtils.getSmallInt(c1a, mesg);
            if (s < 0) {
                throw mesg.getError("err.require.int.nonnegative", c1a);
            }
            byte[] a = new byte[s];
            Arrays.fill(a, (byte)0);
            return new LispBlob(ByteBuffer.wrap(a));
        }
    }
}

