/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispString;

public class SchlushFont
extends Datum {
    public static final Style PLAIN = new Style(0);
    public static final Style BOLD = new Style(1);
    public static final Style ITALIC = new Style(2);
    public static final Style BOLD_ITALIC = new Style(3);
    public LispString SERIF = new LispString("Serif");
    public LispString SANS_SERIF = new LispString("SansSerif");
    public LispString MONOSPACED = new LispString("Monospaced");
    public LispString DIALOG = new LispString("Dialog");
    public LispString DIALOG_INPUT = new LispString("DialogInput");
    Font font;

    public SchlushFont(String name, Style style, int size) {
        this.font = new Font(name, style.style, size);
    }

    public SchlushFont(Font font) {
        this.font = font;
    }

    public static SchlushFont getDefaultFont(String name) {
        return new SchlushFont(Font.getFont(name));
    }

    public SchlushFont transformFont(AffineTransform af) {
        return new SchlushFont(this.font.deriveFont(af));
    }

    public SchlushFont rotateFont(double theta) {
        return this.transformFont(AffineTransform.getRotateInstance(theta));
    }

    public SchlushFont deriveFont(float size) {
        return new SchlushFont(this.font.deriveFont(size));
    }

    public SchlushFont deriveFont(Style style) {
        return new SchlushFont(this.font.deriveFont(style.style));
    }

    public SchlushFont deriveFont(Style style, float size) {
        return new SchlushFont(this.font.deriveFont(style.style, size));
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public boolean isPlain() {
        return this.font.isPlain();
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchlushFont) {
            return this.font.equals(((SchlushFont)obj).font);
        }
        return false;
    }

    public static class Style
    extends Datum {
        private int style;

        private Style(int style) {
            this.style = style;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<font-style>");
        }
    }
}

