/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.SchlushPanelFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.swing.ILispWindow;

public class SchlushWindowFrame
extends SchlushPanelFrame
implements ILispWindow {
    JFrame frame = new JFrame();
    private boolean disposed = false;

    public SchlushWindowFrame(int x, int y, CoordinateMap coordinate) {
        super(coordinate);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(x, y);
        this.frame.add(this.createPanel());
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SchlushWindowFrame.this.disposed = true;
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public SchlushWindowFrame(int x, int y) {
        this(x, y, null);
    }

    @Override
    protected void loadImage(Image img) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.frame);
        mt.addImage(img, 1);
        mt.waitForAll();
    }

    @Override
    public int getHeight() {
        return this.frame.getHeight();
    }

    @Override
    public int getWidth() {
        return this.frame.getWidth();
    }

    @Override
    public int getImageWidth(Image img) {
        return img.getWidth(this.frame);
    }

    @Override
    public int getImageHeight(Image img) {
        return img.getHeight(this.frame);
    }

    @Override
    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        if (!this.disposed) {
            super.addImage(img);
        }
    }

    @Override
    public void addDrawer(Drawer drawer) {
        if (!this.disposed) {
            super.addDrawer(drawer);
        }
    }

    @Override
    public void clearScreen() {
        if (!this.disposed) {
            super.clearScreen();
        }
    }

    @Override
    public void repaint() {
        this.frame.repaint();
    }

    @Override
    public Component getAWTComponent() {
        return this.frame;
    }

    @Override
    public void addWindowListener(WindowListener l) {
        this.frame.addWindowListener(l);
    }

    @Override
    public Window getAWTWindow() {
        return this.frame;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<window-frame>");
    }
}

