/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.r6rs.record.LispR6RSRecord;
import net.morilib.lisp.r6rs.record.LispRecordConstructorDescriptor;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.R6RSRecordInitilizeException;
import net.morilib.lisp.r6rs.record.RCDCreationException;
import net.morilib.lisp.r6rs.record.RTDCreationException;
import net.morilib.lisp.r6rs.record.RecordConstructorDescriptor;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;

public class LispRecordTypeDescriptor
extends Datum2
implements RecordTypeDescriptor {
    String id;
    RecordTypeDescriptor parent;
    String uid;
    boolean sealed;
    boolean opaque;
    Map<String, Boolean> fieldnames;
    private transient Set<String> allfieldnames = null;
    private transient Set<String> inheritedfieldnames = null;
    private static ConcurrentHashMap<String, RecordTypeDescriptor> types = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, RecordTypeDescriptor> uids = new ConcurrentHashMap();

    LispRecordTypeDescriptor(String id, RecordTypeDescriptor parent, String uid, boolean sealed, boolean opaque, Map<String, Boolean> fieldnames) {
        this.id = id;
        this.parent = parent;
        this.uid = uid;
        this.sealed = sealed;
        this.opaque = opaque;
        this.fieldnames = fieldnames;
    }

    public static LispRecordTypeDescriptor newInstance(String id, RecordTypeDescriptor parent, String uid, boolean sealed, boolean opaque, Map<String, Boolean> fieldnames) throws RTDCreationException {
        if (id == null) {
            throw new NullPointerException();
        }
        if (fieldnames == null) {
            throw new NullPointerException();
        }
        if (uid != null && uids.containsKey(uid)) {
            throw new RTDCreationException();
        }
        if (parent != null && parent.isSealed()) {
            throw new RTDCreationException();
        }
        LispRecordTypeDescriptor r = new LispRecordTypeDescriptor(id, parent, uid, sealed, opaque, new LinkedHashMap<String, Boolean>(fieldnames));
        types.put(id, r);
        if (uid != null) {
            uids.put(uid, r);
        }
        return r;
    }

    public static RecordTypeDescriptor getInstance(String id) {
        return types.get(id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RecordTypeDescriptor getParent() {
        return this.parent;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public Set<String> getFieldNames() {
        return this.fieldnames.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllFieldNames() {
        if (this.allfieldnames == null) {
            LispRecordTypeDescriptor lispRecordTypeDescriptor = this;
            synchronized (lispRecordTypeDescriptor) {
                this.allfieldnames = new HashSet<String>();
                RecordTypeDescriptor rtd = this;
                while (rtd != null) {
                    this.allfieldnames.addAll(rtd.getFieldNames());
                    rtd = rtd.getParent();
                }
            }
        }
        return this.allfieldnames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getInheritedFieldNames() {
        if (this.inheritedfieldnames == null) {
            LispRecordTypeDescriptor lispRecordTypeDescriptor = this;
            synchronized (lispRecordTypeDescriptor) {
                this.inheritedfieldnames = new HashSet<String>();
                RecordTypeDescriptor rtd = this.parent;
                while (rtd != null) {
                    this.inheritedfieldnames.addAll(rtd.getFieldNames());
                    rtd = rtd.getParent();
                }
            }
        }
        return this.inheritedfieldnames;
    }

    @Override
    public boolean isMutable(String name) {
        if (Boolean.TRUE.equals(this.fieldnames.get(name))) {
            return true;
        }
        RecordTypeDescriptor rtd = this.parent;
        while (rtd != null) {
            if (rtd.isMutable(name)) {
                return true;
            }
            rtd = rtd.getParent();
        }
        return false;
    }

    @Override
    public boolean hasField(String name) {
        if (this.fieldnames.containsKey(name)) {
            return true;
        }
        RecordTypeDescriptor rtd = this.parent;
        while (rtd != null) {
            if (rtd.hasField(name)) {
                return true;
            }
            rtd = rtd.getParent();
        }
        return false;
    }

    @Override
    public RecordConstructorDescriptor getRcd(RecordTypeDescriptor rtd, RecordConstructorDescriptor parent, Procedure protocol) throws RCDCreationException {
        return new LispRecordConstructorDescriptor(rtd, parent, protocol);
    }

    @Override
    public void initialize(R6RSRecord rd, Datum ... data) throws R6RSRecordInitilizeException {
        if (!(rd instanceof LispR6RSRecord)) {
            throw new R6RSRecordInitilizeException();
        }
        if (!this.isInstance(rd)) {
            throw new R6RSRecordInitilizeException();
        }
        if (rd.getRtd().getFieldNames().size() != data.length) {
            throw new R6RSRecordInitilizeException();
        }
        LispR6RSRecord rr = (LispR6RSRecord)rd;
        int i = 0;
        for (String s : this.fieldnames.keySet()) {
            rr.fields.put(s, data[i++]);
        }
    }

    @Override
    public boolean isInstance(R6RSRecord r) {
        RecordTypeDescriptor rtd = r.getRtd();
        while (rtd != null) {
            if (this.equals(rtd)) {
                return true;
            }
            rtd = rtd.getParent();
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<record-type-descriptor ").append(this.id).append(">");
    }
}

