/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.record.DefaultProtocol;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.R6RSRecordInitilizeException;
import net.morilib.lisp.r6rs.record.RecordConstructorDescriptor;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;
import net.morilib.lisp.subr.UnaryArgs;

public class RecordConstructor
extends UnaryArgs {
    private static void callProtocol(RecordTypeDescriptor rtd, RecordConstructorDescriptor rcd, R6RSRecord r, Datum body, Environment env, LispMessage mesg) {
        Prtcl prt = new Prtcl(rcd, rcd.getRtd(), r);
        Procedure pc = rcd.getProtocol() != null ? rcd.getProtocol() : new DefaultProtocol(rtd);
        Datum p = Scheme.callva(pc, env, mesg, prt);
        if (!(p instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", p);
        }
        Scheme.call(p, env, mesg, body);
    }

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof RecordConstructorDescriptor) {
            RecordConstructorDescriptor rcd = (RecordConstructorDescriptor)((Object)c1a);
            return new Constr(rcd);
        }
        throw mesg.getError("err.r6rsrecord.require.rcd", c1a);
    }

    private static class Constr
    extends Subr {
        private RecordConstructorDescriptor rcd;

        private Constr(RecordConstructorDescriptor rcd) {
            super("record constructor " + rcd.getRtd().getId());
            this.rcd = rcd;
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            R6RSRecord r = this.rcd.newInstance();
            RecordConstructor.callProtocol(this.rcd.getRtd(), this.rcd, r, body, env, mesg);
            return (Datum)((Object)r);
        }
    }

    private static class Prtcl
    extends Subr {
        private RecordConstructorDescriptor rcd;
        private RecordTypeDescriptor rtd;
        private R6RSRecord record;

        private Prtcl(RecordConstructorDescriptor rcd, RecordTypeDescriptor rtd, R6RSRecord record) {
            super("record constructor protocol");
            this.rcd = rcd;
            this.rtd = rtd;
            this.record = record;
        }

        private Datum callr(Datum body, LispMessage mesg) {
            Datum[] d = LispUtils.consToArray(body, mesg);
            try {
                this.rtd.initialize(this.record, d);
                return (Datum)((Object)this.record);
            }
            catch (R6RSRecordInitilizeException e) {
                throw mesg.getError("err.r6rsrecord.initialize.record");
            }
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            RecordTypeDescriptor rtd2 = this.rtd.getParent();
            RecordConstructorDescriptor rcd2 = this.rcd.getParent();
            if (rtd2 == null) {
                return this.callr(body, mesg);
            }
            RecordConstructor.callProtocol(rtd2, rcd2, this.record, body, env, mesg);
            return new Subr("protocol"){

                @Override
                public Datum eval(Datum body, Environment env, LispMessage mesg) {
                    return Prtcl.this.callr(body, mesg);
                }
            };
        }
    }
}

