/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.serialize;

import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispJavaUtils;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.UnaryArgs;

public class ImportDatumXml
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        XMLDecoder ois = null;
        try {
            File s = LispFiles.getFile(env, c1a, mesg);
            ois = new XMLDecoder(new FileInputStream(s));
            Datum datum = LispJavaUtils.newInstance(ois.readObject());
            return datum;
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw mesg.getError("err.serialize.cannot.serialize");
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }
}

