/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.algebra.ILispNumberEqual;
import net.morilib.lisp.subr.SubrUtils;

public class NumEqual
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ILispNumberEqual p = null;
        Datum d = Nil.NIL;
        while (itr.hasNext()) {
            try {
                d = itr.next();
                if (!(d instanceof ILispNumberEqual)) {
                    throw mesg.getError("err.require.number", d);
                }
                if (p != null && !p.isEqualTo(d)) {
                    return LispBoolean.FALSE;
                }
                p = (ILispNumberEqual)((Object)d);
            }
            catch (ClassCastException e) {
                throw mesg.getError("err.math.mismatch", d);
            }
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return LispBoolean.TRUE;
    }

    @Override
    public String toString() {
        return "Subr:=";
    }
}

