/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Container;
import java.awt.GridLayout;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.swing.ILispComponent;
import net.morilib.lisp.swing.ILispComposite;

public class LayoutGrid
extends Subr {
    private GridLayout addGrid(final Container comp, Datum d, final LispMessage mesg) {
        LispUtils.CallTable<GridLayout, Datum> maktbl = new LispUtils.CallTable<GridLayout, Datum>(){

            @Override
            public GridLayout create(int rows, int cols) {
                GridLayout g = new GridLayout(rows, cols);
                comp.setLayout(g);
                return g;
            }

            @Override
            public void call(GridLayout tbl, int r, int c, Datum t) {
                if (!(t instanceof ILispComponent)) {
                    throw mesg.getError("err.swing.require.component", t);
                }
                comp.add(((ILispComponent)((Object)t)).getComponent());
            }
        };
        return LispUtils.consToTable(d, mesg, maktbl);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 2) {
            if (!(l.get(0) instanceof ILispComposite)) {
                throw mesg.getError("err.swing.require.composite", l.get(0));
            }
            GridLayout r = this.addGrid(((ILispComposite)((Object)l.get(0))).getPane(), l.get(1), mesg);
        } else if (l.size() == 4) {
            if (!(l.get(0) instanceof ILispComposite)) {
                throw mesg.getError("err.swing.require.composite", l.get(0));
            }
            if (!(l.get(2) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(2));
            }
            if (!(l.get(3) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(3));
            }
            GridLayout r = this.addGrid(((ILispComposite)((Object)l.get(0))).getPane(), l.get(1), mesg);
            r.setHgap(l.get(2).getInt());
            r.setVgap(l.get(3).getInt());
        } else {
            throw mesg.getError("err.argument", body);
        }
        return Undef.UNDEF;
    }
}

