/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.lisp.swing.listener.ActionListenable;

public class LispMenuItem
extends Datum2
implements ActionListenable,
JavaObjective {
    JMenuItem item;

    public LispMenuItem(JMenuItem item) {
        this.item = item;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.item.addActionListener(listener);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<menu-item>");
    }

    @Override
    public Object toObject() {
        return this.item;
    }

    public static class MakeMenuItem
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JMenuItem m;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 2) {
                String t = SubrUtils.getString(l.get(0), mesg);
                m = new JMenuItem(t);
                m.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
            } else if (l.size() == 4) {
                String t = SubrUtils.getString(l.get(0), mesg);
                m = new JMenuItem(t);
                m.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
                m.setAccelerator(LispSwing.toKeyStroke(l.get(2), l.get(3), mesg));
            } else {
                throw mesg.getError("err.argument", body);
            }
            return new LispMenuItem(m);
        }
    }
}

