/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.table;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Undef;
import net.morilib.lisp.swing.table.AbstractLispTableModel;
import net.morilib.lisp.swing.table.LispDefaulTableColumnNameModel;
import net.morilib.lisp.swing.table.MyTableColumnNameModel;

public class LispMutableTableModel
extends AbstractLispTableModel {
    public static final MyTableColumnNameModel DEFAULT_COLUMN_NAME = new MyTableColumnNameModel(){

        @Override
        public String getColumnName(int column) {
            return Integer.toString(column + 1);
        }

        @Override
        public void addColumn(Object columnName) {
        }
    };
    private List<List<Datum>> table;
    private MyTableColumnNameModel columnNameModel;
    private int columns;

    public LispMutableTableModel(Datum d, MyTableColumnNameModel columnNameModel) {
        this._inittable(d);
        this.columnNameModel = columnNameModel;
    }

    public LispMutableTableModel(Datum d, Datum columnNames) {
        ConsIterator itr = new ConsIterator(d);
        this._inittable(d);
        ArrayList<Datum> l = new ArrayList<Datum>();
        itr = new ConsIterator(columnNames);
        while (itr.hasNext()) {
            l.add(itr.next());
        }
        if (l.size() != this.columns) {
            throw new IllegalArgumentException();
        }
        this.columnNameModel = new LispDefaulTableColumnNameModel(l, false);
    }

    public LispMutableTableModel(Datum d) {
        this(d, DEFAULT_COLUMN_NAME);
    }

    private void _inittable(Datum d) {
        ConsIterator itr = new ConsIterator(d);
        int c = -1;
        this.table = new ArrayList<List<Datum>>();
        while (itr.hasNext()) {
            Datum e = itr.next();
            if (!e.isNil() && !(e instanceof Cons)) {
                throw new IllegalArgumentException();
            }
            ConsIterator jtr = new ConsIterator(e);
            ArrayList<Datum> l = new ArrayList<Datum>();
            while (jtr.hasNext()) {
                l.add(jtr.next());
            }
            this.table.add(l);
            c = Math.max(c, l.size());
        }
        this.columns = c;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getColumnCount1(int rowIndex) {
        return this.table.get(rowIndex).size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNameModel.getColumnName(columnIndex);
    }

    @Override
    public void setValueAt(Object val, int r, int c) {
        List<Datum> l = this.table.get(r);
        if (c < l.size()) {
            l.set(c, (Datum)val);
        } else {
            int i = l.size();
            while (i < c) {
                l.add(Undef.UNDEF);
                ++i;
            }
            l.add((Datum)val);
        }
        this.fireTableCellUpdated(r, c);
    }

    @Override
    public Datum getValueAt(int r, int c) {
        List<Datum> l = this.table.get(r);
        return c < l.size() ? l.get(c) : Undef.UNDEF;
    }

    @Override
    public void addColumn(Datum name) {
        this.addColumn(name, Nil.NIL);
    }

    @Override
    public void addColumn(Datum name, Datum d) {
        this.columnNameModel.addColumn(name.isTrue() ? name : LispInteger.valueOf(this.columns + 1));
        ConsIterator itr = new ConsIterator(d);
        int r = 0;
        while (itr.hasNext()) {
            List<Object> l;
            if (r < this.table.size()) {
                l = this.table.get(r);
            } else {
                l = new ArrayList();
                this.table.add(l);
            }
            int i = l.size();
            while (i < this.columns) {
                l.add(Undef.UNDEF);
                ++i;
            }
            l.add(itr.next());
            ++r;
        }
        ++this.columns;
        this.fireTableStructureChanged();
    }

    @Override
    public void addRow(Datum d) {
        this.insertRow(this.table.size(), d);
    }

    @Override
    public void insertRow(int row, Datum d) {
        ConsIterator itr = new ConsIterator(d);
        ArrayList<Datum> l = new ArrayList<Datum>();
        int i = 0;
        while (i < this.columns && itr.hasNext()) {
            l.add(itr.next());
            ++i;
        }
        this.table.add(row, l);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public void moveRow(int start, int end, int to) {
        if (start < to) {
            ArrayList<List<Datum>> t = new ArrayList<List<Datum>>();
            int i = start;
            while (i < end) {
                t.add(this.table.get(i));
                this.table.remove(i);
                ++i;
            }
            i = 0;
            while (i < t.size()) {
                this.table.add(to - start + i, (List)t.get(i));
                ++i;
            }
            this.fireTableRowsInserted(start, end);
        } else if (start != to) {
            ArrayList<List<Datum>> t = new ArrayList<List<Datum>>();
            int i = start;
            while (i < end) {
                t.add(this.table.get(i));
                this.table.remove(i);
                ++i;
            }
            i = 0;
            while (i < t.size()) {
                this.table.add(to, (List)t.get(i));
                ++i;
            }
            this.fireTableRowsInserted(start, end);
        }
    }

    @Override
    public void removeRow(int row) {
        this.table.remove(row);
        this.fireTableRowsDeleted(row, row);
    }
}

