/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.util;

import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Timer;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.lisp.swing.util.LispSwingTimer;
import net.morilib.util.Iterators;

public class MakeSwingTimer
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        int delay = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c3a = Iterators.nextIf(itr);
        Datum c4a = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (delay < 0) {
            throw mesg.getError("err.require.int.nonnegative", delay);
        }
        ActionListener l = LispSwing.createActionListener(c2a, env, mesg);
        Timer t = new Timer(delay, l);
        if (c3a == null) {
            t.setRepeats(true);
        } else if (!c3a.isTrue()) {
            t.setRepeats(false);
        } else {
            t.setRepeats(true);
            int edelay = SubrUtils.getSmallInt(c3a, mesg);
            if (edelay < 0) {
                throw mesg.getError("err.require.int.nonnegative", edelay);
            }
            t.setDelay(edelay);
        }
        if (c4a != null) {
            t.setActionCommand(LispUtils.print(c4a));
        }
        return new LispSwingTimer(t);
    }
}

