/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.zip;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.r6rs.io.LispFileOptions;
import net.morilib.lisp.r6rs.io.LispOutputStreamPort;
import net.morilib.lisp.r6rs.io.LispTextualOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class GzipFileOutputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum op = Iterators.nextIf(itr, LispFileOptions.DEFAULT);
        Datum bm = Iterators.nextIf(itr, LispBufferMode.BLOCK);
        Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(op instanceof LispFileOptions)) {
            throw mesg.getError("err.io.require.fileoptions", op);
        }
        if (!(bm instanceof LispBufferMode)) {
            throw mesg.getError("err.io.require.buffermode", bm);
        }
        if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", tr);
        }
        try {
            GZIPOutputStream ous = new GZIPOutputStream(new FileOutputStream(LispFiles.getFile(env, c1a, mesg)));
            if (tr.isTrue()) {
                return new LispTextualOutputPort(((ILispTranscoder)((Object)tr)).newOutput(ous), (ILispTranscoder)((Object)tr), (LispBufferMode)bm);
            }
            return new LispOutputStreamPort(ous, (LispBufferMode)bm);
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

