/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.order;

import java.util.Collections;
import java.util.Set;
import net.morilib.math.order.OrderElement;
import net.morilib.math.order.PolynomialOrder;

class ExponentialOrder
extends OrderElement {
    int order;

    ExponentialOrder(int order) {
        this.order = order;
    }

    @Override
    public int level() {
        return 85;
    }

    @Override
    public OrderElement multiply(OrderElement o) {
        return this.compareTo(o) < 0 ? o : this;
    }

    @Override
    public Set<OrderElement> log() {
        return Collections.singleton(new PolynomialOrder(this.order));
    }

    @Override
    public int compareLevel(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.order < ((ExponentialOrder)o).order) {
            return -1;
        }
        if (this.order > ((ExponentialOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(OrderElement o) {
        if (this.level() < o.level()) {
            return -1;
        }
        if (this.level() > o.level()) {
            return 1;
        }
        if (this.order < ((ExponentialOrder)o).order) {
            return -1;
        }
        if (this.order > ((ExponentialOrder)o).order) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isConstant() {
        return this.order == 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.order == 0) {
            return "1";
        }
        int i = 0;
        while (i < 1) {
            b.append("c^");
            ++i;
        }
        b.append("n");
        if (this.order != 1) {
            b.append("^").append(this.order);
        }
        return b.toString();
    }
}

