/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.order;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.math.order.ExponentialOrder;
import net.morilib.math.order.FactorialOrder;
import net.morilib.math.order.LogarithmicOrder;
import net.morilib.math.order.OrderElement;
import net.morilib.math.order.PolynomialOrder;

public class OrderNotation
implements Comparable<OrderNotation> {
    public static final OrderNotation CONSTANT = new OrderNotation();
    private SortedSet<OrderElement> elements;

    OrderNotation() {
        this.elements = new TreeSet<OrderElement>();
    }

    OrderNotation(OrderElement e) {
        this.elements = new TreeSet<OrderElement>();
        this.elements.add(e);
    }

    OrderNotation(SortedSet<OrderElement> es) {
        this.elements = es;
    }

    public static final OrderNotation polynomial(int n) {
        if (n != 0) {
            return new OrderNotation(new PolynomialOrder(n));
        }
        return CONSTANT;
    }

    public static final OrderNotation exp(int n) {
        if (n != 0) {
            return new OrderNotation(new ExponentialOrder(n));
        }
        return CONSTANT;
    }

    public static final OrderNotation log(int level, int n) {
        if (level < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return CONSTANT;
        }
        if (level == 0) {
            return OrderNotation.polynomial(n);
        }
        return new OrderNotation(new LogarithmicOrder(n, level));
    }

    public static final OrderNotation factorial(int n) {
        if (n != 0) {
            return new OrderNotation(new FactorialOrder(n));
        }
        return CONSTANT;
    }

    private static <T> T next(Iterator<T> i) {
        return i.hasNext() ? (T)i.next() : null;
    }

    private OrderNotation reduce() {
        return this;
    }

    public OrderNotation add(OrderNotation o) {
        return this.compareTo(o) > 0 ? this : o;
    }

    public OrderNotation subtract(OrderNotation o) {
        return this.compareTo(o) > 0 ? this : o;
    }

    public OrderNotation multiply(OrderNotation o) {
        TreeSet<OrderElement> r = new TreeSet<OrderElement>();
        Iterator i = this.elements.iterator();
        Iterator j = o.elements.iterator();
        OrderElement b = null;
        OrderElement a = null;
        while (a != null || i.hasNext() || b != null || j.hasNext()) {
            int x;
            if (!i.hasNext() && a != null) {
                r.add(a);
                a = null;
                continue;
            }
            if (!j.hasNext() && b != null) {
                r.add(b);
                b = null;
                continue;
            }
            if (a == null && i.hasNext()) {
                a = (OrderElement)OrderNotation.next(i);
            }
            if (b == null && j.hasNext()) {
                b = (OrderElement)OrderNotation.next(j);
            }
            if ((x = a.compareLevel(b)) < 0) {
                r.add(a);
                a = (OrderElement)OrderNotation.next(i);
                continue;
            }
            if (x > 0) {
                r.add(b);
                b = (OrderElement)OrderNotation.next(j);
                continue;
            }
            OrderElement c = a.multiply(b);
            if (!c.isConstant()) {
                r.add(c);
            }
            a = (OrderElement)OrderNotation.next(i);
            b = (OrderElement)OrderNotation.next(j);
        }
        return new OrderNotation(r).reduce();
    }

    public OrderNotation log() {
        if (this.elements.isEmpty()) {
            throw new ArithmeticException();
        }
        return new OrderNotation(new TreeSet<OrderElement>(this.elements.last().log()));
    }

    @Override
    public int compareTo(OrderNotation o) {
        return this.elements.last().compareTo(o.elements.last());
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof OrderNotation && this.compareTo((OrderNotation)o) == 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("O(");
        String dlm = "";
        if (this.elements.isEmpty()) {
            b.append("1");
        } else {
            for (OrderElement e : this.elements) {
                b.append(dlm).append(e);
                dlm = "*";
            }
        }
        return b.append(")").toString();
    }
}

