/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.polynomial1;

import net.morilib.math.polynomial1.DoublePolynomial1;

public final class Polynomial1Utils {
    private static final DoublePolynomial1 X = new DoublePolynomial1(0.0, -1.0);
    private static final double ALPHA = 0.72;

    private Polynomial1Utils() {
    }

    public static double[][] solveByBairstow1(DoublePolynomial1 p0, double epsilon, int iterate) {
        double p = 0.0;
        double[][] res = new double[p0.degree()][2];
        int i = 0;
        if (p0.degree() == 0) {
            return null;
        }
        DoublePolynomial1 p1 = p0.div(p0.coefficient(p0.degree()));
        while (true) {
            double d;
            double D;
            p = p1.coefficient(1);
            double q = p1.coefficient(0);
            DoublePolynomial1 g = null;
            block0 : switch (p1.degree()) {
                case 0: {
                    return res;
                }
                case 1: {
                    res[i][0] = -p1.coefficient(0);
                    res[i][1] = 0.0;
                    return res;
                }
                default: {
                    double[] dArray = p1.coefficients;
                    int n = p1.coefficients.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double x = dArray[n2];
                        p += x / (double)p1.coefficients.length;
                        ++n2;
                    }
                    q = p + 0.72 * p;
                    int c = 0;
                    while (true) {
                        DoublePolynomial1 p2 = new DoublePolynomial1(q, p, 1.0);
                        DoublePolynomial1[] q0 = p1.divAndRemainder(p2);
                        g = q0[0];
                        DoublePolynomial1 q1 = q0[1];
                        double s = q1.coefficient(0);
                        double r = q1.coefficient(1);
                        DoublePolynomial1 q2 = g.multiply(X).divAndRemainder(p2)[1];
                        DoublePolynomial1 q3 = g.uminus().divAndRemainder(p2)[1];
                        double a11 = q2.coefficient(1);
                        double a12 = q3.coefficient(1);
                        double a21 = q2.coefficient(0);
                        double a22 = q3.coefficient(0);
                        double b1 = -r;
                        double b2 = -s;
                        D = a11 * a22 - a12 * a21;
                        if (D == 0.0) {
                            q += 0.72 * q;
                        } else {
                            double dp = (a22 * b1 - a12 * b2) / D;
                            double dq = (-a21 * b1 + a11 * b2) / D;
                            if (Math.abs(dp / p) < epsilon && Math.abs(dq / p) < epsilon) break block0;
                            if (c > iterate) {
                                return null;
                            }
                            p += 0.72 * dp;
                            q += 0.72 * dq;
                        }
                        ++c;
                    }
                }
                case 2: 
            }
            D = p * p - 4.0 * q;
            if (d < 0.0) {
                double d2 = -p / 2.0;
                res[i + 1][0] = d2;
                res[i][0] = d2;
                res[i][1] = Math.sqrt(-D) / 2.0;
                res[i + 1][1] = -res[i][1];
            } else {
                res[i + 1][1] = 0.0;
                res[i][1] = 0.0;
                res[i][0] = (-p + Math.sqrt(D)) / 2.0;
                res[i + 1][0] = (-p - Math.sqrt(D)) / 2.0;
            }
            if (p1.degree() == 2) {
                return res;
            }
            p1 = g;
            i += 2;
        }
    }
}

