/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ntp;

public enum NTPLeapIndicator {
    NORMAL(0),
    LAST_MINUTE_HAS_61SECONDS(1),
    LAST_MINUTE_HAS_59SECONDS(2),
    WARNING(3);

    private int cd;

    private NTPLeapIndicator(int cd) {
        this.cd = cd;
    }

    public static NTPLeapIndicator getFromNTPBits(int bt) {
        switch (bt >> 6 & 3) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return LAST_MINUTE_HAS_61SECONDS;
            }
            case 2: {
                return LAST_MINUTE_HAS_59SECONDS;
            }
            case 3: {
                return WARNING;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getCode() {
        return this.cd;
    }
}

