/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.util.Arrays;
import net.morilib.net.snmp.ASN1;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ASN1TagBoolean;
import net.morilib.net.snmp.ASN1TagCounter32;
import net.morilib.net.snmp.ASN1TagCounter64;
import net.morilib.net.snmp.ASN1TagGeneralizedTime;
import net.morilib.net.snmp.ASN1TagInteger;
import net.morilib.net.snmp.ASN1TagIpAddress;
import net.morilib.net.snmp.ASN1TagNull;
import net.morilib.net.snmp.ASN1TagOID;
import net.morilib.net.snmp.ASN1TagSet;
import net.morilib.net.snmp.ASN1TagString;
import net.morilib.net.snmp.ASN1TagTimeTicks;
import net.morilib.net.snmp.ASN1TagUTCTime;
import net.morilib.net.snmp.ASN1TagUnsigned32;

public class ASN1Tag {
    public static final ASN1Tag BOOLEAN = new ASN1TagBoolean();
    public static final ASN1Tag INTEGER = new ASN1TagInteger();
    public static final ASN1Tag BIT_STRING = new ASN1Tag(0, false, 3);
    public static final ASN1Tag OCTET_STRING = new ASN1TagString(4);
    public static final ASN1Tag NULL = new ASN1TagNull();
    public static final ASN1Tag OID = new ASN1TagOID();
    public static final ASN1Tag OBJECT_DESCRIPTOR = new ASN1TagString(7);
    public static final ASN1Tag REAL = new ASN1Tag(0, false, 9);
    public static final ASN1Tag UTF8STRING = new ASN1TagString(12);
    public static final ASN1Tag SEQUENCE = new ASN1Tag(0, true, 16);
    public static final ASN1Tag SET = new ASN1TagSet();
    public static final ASN1Tag NUMERIC_STRING = new ASN1TagString(18);
    public static final ASN1Tag PRINTABLE_STRING = new ASN1TagString(19);
    public static final ASN1Tag TELETEX_STRING = new ASN1TagString(20);
    public static final ASN1Tag IA5STRING = new ASN1TagString(22);
    public static final ASN1Tag UTC_TIME = new ASN1TagUTCTime();
    public static final ASN1Tag GENERALIZED_TIME = new ASN1TagGeneralizedTime();
    public static final ASN1Tag IP_ADDRESS = new ASN1TagIpAddress();
    public static final ASN1Tag COUNTER32 = new ASN1TagCounter32();
    public static final ASN1Tag UNSIGNED32 = new ASN1TagUnsigned32();
    public static final ASN1Tag TIME_TICKS = new ASN1TagTimeTicks();
    public static final ASN1Tag COUNTER64 = new ASN1TagCounter64();
    private static final ASN1Tag[] _POOL;
    private static final String[] _POOL_STR;
    private static final ASN1Tag[] _POOL1;
    private static final String[] _POOL_STR1;
    private static final String[] _CLASS_STR;
    private byte no;
    private byte[] extendedNo;
    private int asnClass;
    private boolean structured;

    static {
        ASN1Tag[] aSN1TagArray = new ASN1Tag[33];
        aSN1TagArray[1] = BOOLEAN;
        aSN1TagArray[2] = INTEGER;
        aSN1TagArray[3] = BIT_STRING;
        aSN1TagArray[4] = OCTET_STRING;
        aSN1TagArray[5] = NULL;
        aSN1TagArray[6] = OID;
        aSN1TagArray[7] = OBJECT_DESCRIPTOR;
        aSN1TagArray[9] = REAL;
        aSN1TagArray[13] = UTF8STRING;
        aSN1TagArray[17] = SEQUENCE;
        aSN1TagArray[18] = SET;
        aSN1TagArray[19] = NUMERIC_STRING;
        aSN1TagArray[20] = PRINTABLE_STRING;
        aSN1TagArray[21] = TELETEX_STRING;
        aSN1TagArray[23] = IA5STRING;
        aSN1TagArray[24] = UTC_TIME;
        aSN1TagArray[25] = GENERALIZED_TIME;
        _POOL = aSN1TagArray;
        String[] stringArray = new String[33];
        stringArray[1] = "BOOLEAN";
        stringArray[2] = "INTEGER";
        stringArray[3] = "BIT_STRING";
        stringArray[4] = "OCTET_STRING";
        stringArray[5] = "NULL";
        stringArray[6] = "OBJECT_IDENTIFIER";
        stringArray[7] = "ObjectDescriptor";
        stringArray[9] = "REAL";
        stringArray[13] = "UTF8String";
        stringArray[17] = "SEQUENCE";
        stringArray[18] = "SET";
        stringArray[19] = "NumericString";
        stringArray[20] = "PrintableString";
        stringArray[21] = "TeletexString";
        stringArray[23] = "IA5String";
        stringArray[24] = "UTCTime";
        stringArray[25] = "GeneralizedTime";
        _POOL_STR = stringArray;
        ASN1Tag[] aSN1TagArray2 = new ASN1Tag[32];
        aSN1TagArray2[0] = IP_ADDRESS;
        aSN1TagArray2[1] = COUNTER32;
        aSN1TagArray2[2] = UNSIGNED32;
        aSN1TagArray2[3] = TIME_TICKS;
        aSN1TagArray2[6] = COUNTER64;
        _POOL1 = aSN1TagArray2;
        String[] stringArray2 = new String[32];
        stringArray2[0] = "IpAddress";
        stringArray2[1] = "Counter32";
        stringArray2[2] = "Unsigned32";
        stringArray2[3] = "TimeTicks";
        stringArray2[6] = "Counter64";
        _POOL_STR1 = stringArray2;
        _CLASS_STR = new String[]{"GENERIC:", "APPLICATION:", "CONTEXT:", "PRIVATE:"};
    }

    public ASN1Tag(int asnClass, boolean structured, byte[] no) {
        if (no == null) {
            throw new NullPointerException();
        }
        if (asnClass < 0 || asnClass > 3) {
            throw new IllegalArgumentException();
        }
        this.asnClass = asnClass;
        this.structured = structured;
        this.no = (byte)31;
        this.extendedNo = new byte[no.length];
        System.arraycopy(no, 0, this.no, 0, no.length);
    }

    ASN1Tag(int asnClass, boolean structured, byte no) {
        if (no < 0 || no >= 31) {
            throw new IllegalArgumentException();
        }
        if (asnClass < 0 || asnClass > 3) {
            throw new IllegalArgumentException();
        }
        this.asnClass = asnClass;
        this.structured = structured;
        this.extendedNo = null;
        this.no = no;
    }

    public static ASN1Tag getInstance(int asnClass, boolean structured, int no) {
        if (no < 0 || no >= _POOL.length) {
            throw new IllegalArgumentException();
        }
        if (asnClass == 0 && _POOL[no] != null) {
            return _POOL[no];
        }
        if (asnClass == 1 && _POOL1[no] != null) {
            return _POOL1[no];
        }
        return new ASN1Tag(asnClass, structured, (byte)no);
    }

    public boolean isStructured() {
        return this.structured;
    }

    protected Object analyse(byte[] bts) throws ASN1Exception {
        return this.structured ? (Object)ASN1.readSequence(bts) : bts;
    }

    public boolean equals(Object o) {
        if (o instanceof ASN1Tag) {
            ASN1Tag t = (ASN1Tag)o;
            return this.asnClass == t.asnClass && this.no == t.no && Arrays.equals(this.extendedNo, t.extendedNo);
        }
        return false;
    }

    public int hashCode() {
        int r = 31;
        r = 17 * r + this.asnClass;
        r = 17 * r + this.no;
        r = 17 * r + Arrays.hashCode(this.extendedNo);
        return r;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(_CLASS_STR[this.asnClass]);
        if (this.asnClass == 0 && _POOL_STR[this.no] == null) {
            b.append(_POOL_STR[this.no]);
        } else if (this.asnClass == 1 && _POOL1[this.no] != null) {
            b.append(_POOL_STR1[this.no]);
        } else {
            b.append(this.no);
        }
        return b.toString();
    }
}

