/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public class ObjectIdentifier {
    private int[] oid;

    public ObjectIdentifier(int[] o) {
        this.oid = new int[o.length];
        System.arraycopy(o, 0, this.oid, 0, o.length);
    }

    ObjectIdentifier(int[] o, boolean f) {
        this.oid = o;
    }

    public byte[] toBytes() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        int c = 0;
        b.write(this.oid[0] * 40 + this.oid[1]);
        int i = 2;
        while (i < this.oid.length) {
            if (c == 0 && (c = this.oid[i]) == 0) {
                b.write(0);
            } else if ((c & 0xF0000000) != 0) {
                b.write(c >>> 28 | 0x80);
            } else if ((c & 0xFE00000) != 0) {
                b.write(c >>> 21 | 0x80);
            } else if ((c & 0x1FC000) != 0) {
                b.write(c >>> 14 | 0x80);
            } else if ((c & 0x3F80) != 0) {
                b.write(c >>> 7 | 0x80);
            } else {
                b.write(c & 0x7F);
            }
            c >>>= 7;
            ++i;
        }
        return b.toByteArray();
    }

    public static ObjectIdentifier parse(String s) {
        String[] ss = s.split("\\.");
        int[] rr = new int[ss.length];
        int i = 0;
        while (i < ss.length) {
            BigInteger x = new BigInteger(ss[i]);
            if (x.signum() < 0 && x.bitLength() > 31) {
                throw new IllegalArgumentException();
            }
            rr[i] = x.intValue();
            ++i;
        }
        return new ObjectIdentifier(rr, false);
    }

    public boolean isSubTreeOf(ObjectIdentifier oid1) {
        if (this.oid.length > oid1.oid.length) {
            int i = 0;
            while (i < oid1.oid.length) {
                if (this.oid[i] != oid1.oid[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.oid);
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectIdentifier) {
            return Arrays.equals(this.oid, ((ObjectIdentifier)o).oid);
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String dlm = "";
        int i = 0;
        while (i < this.oid.length) {
            b.append(dlm).append(this.oid[i]);
            dlm = ".";
            ++i;
        }
        return b.toString();
    }
}

