/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import net.morilib.util.Objects;
import net.morilib.util.SimpleMap;

public class MappedCollection<F, E>
extends AbstractCollection<E> {
    private Collection<? extends F> wrapee;
    private SimpleMap<F, E> composite;

    public MappedCollection(Collection<? extends F> col, SimpleMap<F, E> map) {
        this.wrapee = col;
        this.composite = map;
    }

    @Override
    public int size() {
        return this.wrapee.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapee.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (F f : this.wrapee) {
            if (!Objects.equals(this.composite.map(f), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<? extends F> wrp;
            {
                this.wrp = MappedCollection.this.wrapee.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrp.hasNext();
            }

            @Override
            public E next() {
                return MappedCollection.this.composite.map(this.wrp.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

