/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morilib.util.io.IllegalUTFException;

public final class UTF16 {
    public static final boolean LITTLE_ENDIAN = false;
    public static final boolean BIG_ENDIAN = true;

    private UTF16() {
    }

    public static int[] getInts(String s) {
        int c;
        int len = 0;
        if (s == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < s.length()) {
            i += (c = s.codePointAt(i)) > 65535 ? 2 : 1;
            ++len;
        }
        int[] r = new int[len];
        len = 0;
        i = 0;
        while (i < s.length()) {
            c = s.codePointAt(i);
            r[len++] = s.codePointAt(i);
            i += c > 65535 ? 2 : 1;
        }
        return r;
    }

    public static String toString(int[] cd, int off, int len) {
        StringBuilder b = new StringBuilder();
        int i = off;
        while (i < len) {
            b.appendCodePoint(cd[i]);
            ++i;
        }
        return b.toString();
    }

    public static String toString(int[] cd) {
        return UTF16.toString(cd, 0, cd.length);
    }

    public static int read(InputStream ins, boolean endian) throws IOException {
        int c;
        int state = 0;
        int r = 0;
        int s = 0;
        while ((c = ins.read()) >= 0) {
            switch (state) {
                case 0: {
                    r = endian ? c << 8 : c;
                    state = 1;
                    break;
                }
                case 1: {
                    if (((r |= endian ? c : c << 8) & 0xFC00) == 55296) {
                        s = ((r & 0x3C0) + 64 | r & 0x3F) << 10;
                        state = 2;
                        break;
                    }
                    state = 0;
                    return r;
                }
                case 2: {
                    r = endian ? c << 8 : c;
                    state = 3;
                    break;
                }
                case 3: {
                    if (((r |= endian ? c : c << 8) & 0xFC00) == 56320) {
                        state = 0;
                        return s |= r & 0x3FF;
                    }
                    throw new IllegalUTFException();
                }
            }
        }
        if (state != 0) {
            throw new IllegalUTFException();
        }
        return c;
    }

    public static void write(OutputStream ous, int c, boolean endian) throws IOException {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalUTFException();
        }
        if (c < 65536) {
            ous.write((endian ? c >> 8 : c) & 0xFF);
            ous.write((endian ? c : c >> 8) & 0xFF);
        } else {
            int s = (c >> 10) - 64 | 0xD800;
            int t = c & 0x3FF | 0xDC00;
            ous.write((endian ? s >> 8 : s) & 0xFF);
            ous.write((endian ? s : s >> 8) & 0xFF);
            ous.write((endian ? t >> 8 : t) & 0xFF);
            ous.write((endian ? t : t >> 8) & 0xFF);
        }
    }

    public static boolean readBOM(InputStream ins) throws IOException {
        int c = ins.read();
        if (c == 254) {
            c = ins.read();
            if (c == 255) {
                return true;
            }
            throw new IllegalUTFException();
        }
        if (c == 255) {
            c = ins.read();
            if (c == 254) {
                return false;
            }
            throw new IllegalUTFException();
        }
        throw new IllegalUTFException();
    }
}

