/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractIntegerVector;
import net.morilib.util.primitive.IntegerCollection;

public class IntegerArrayVector
extends AbstractIntegerVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private int[] array;
    private transient int size;

    public IntegerArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new int[initialCapacity];
    }

    public IntegerArrayVector() {
        this(10);
    }

    public IntegerArrayVector(int[] bytes) {
        this.array = new int[bytes.length];
        this.size = this.array.length;
        System.arraycopy(bytes, 0, this.array, 0, bytes.length);
    }

    public IntegerArrayVector(IntegerCollection a) {
        this.array = a.toIntArray();
        this.size = this.array.length;
    }

    public IntegerArrayVector(IntegerCollection ... as) {
        this.size = 0;
        IntegerCollection[] integerCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerCollection a = integerCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new int[this.size];
        IntegerCollection[] integerCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            IntegerCollection a = integerCollectionArray2[n];
            int[] b = a.toIntArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public IntegerArrayVector(Collection<? extends IntegerCollection> as) {
        this.size = 0;
        for (IntegerCollection integerCollection : as) {
            this.size += integerCollection.size();
        }
        boolean bl = false;
        this.array = new int[this.size];
        for (IntegerCollection integerCollection : as) {
            void var2_7;
            int[] b = integerCollection.toIntArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += integerCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            int[] b = new int[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addInt(int index, int v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllInt(int index, IntegerCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        int[] b = a.toIntArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public int getInt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public int removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public int setInt(int index, int v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllInt(IntegerCollection a) {
        int[] b = a.toIntArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllInt(IntegerCollection ... as) {
        int nsize = 0;
        IntegerCollection[] integerCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerCollection a = integerCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            IntegerCollection[] integerCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                IntegerCollection a = integerCollectionArray2[n];
                int[] b = a.toIntArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllInt(Collection<? extends IntegerCollection> as) {
        int nsize = 0;
        for (IntegerCollection integerCollection : as) {
            nsize += integerCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (IntegerCollection integerCollection : as) {
                void var3_8;
                int[] b = integerCollection.toIntArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += integerCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAllInt(int[] b) {
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllInt(int index, int[] b) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (b.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] toIntArray() {
        int[] b = new int[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public int[] toIntArray(int[] a) {
        if (a.length < this.size) {
            return this.toIntArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

