/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractIntegerCollection;
import net.morilib.util.primitive.AbstractIntegerVector;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.IntegerList;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.IntegerSortedSet;
import net.morilib.util.primitive.IntegerVector;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.iterator.IntegerIterators;
import net.morilib.util.primitive.iterator.IntegerVectorIterator;

public final class IntegerCollections {
    public static final IntegerSet EMPTY_SET = new _EmptyS();
    public static final IntegerSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final IntegerVector EMPTY_VECTOR = new _EmptyV();

    private IntegerCollections() {
    }

    public static IntegerCollection unmodifiableCollection(IntegerCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static IntegerSet unmodifiableSet(IntegerSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static IntegerSortedSet unmodifiableSortedSet(IntegerSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    static class UnmodifiableCol
    extends AbstractIntegerCollection {
        IntegerCollection wrapee;

        UnmodifiableCol(IntegerCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(IntegerCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(Collection<? extends IntegerCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsInt(int v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllInt(IntegerCollection a) {
            return this.wrapee.containsAllInt(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public IntegerIterator intIterator() {
            return new Itr(this.wrapee.intIterator());
        }

        @Override
        public boolean removeInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public int[] toIntArray() {
            return this.wrapee.toIntArray();
        }

        @Override
        public int[] toIntArray(int[] a) {
            return this.wrapee.toIntArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public IntegerSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements IntegerIterator {
            private IntegerIterator itr;

            private Itr(IntegerIterator itr) {
                this.itr = itr;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public int next() {
                return this.itr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements IntegerSortedSet {
        UnmodifiableSSet(IntegerCollection s) {
            super(s);
        }

        @Override
        public IntegerSortedSet collect(IntegerSortedSet set) {
            return ((IntegerSortedSet)this.wrapee).collect(set);
        }

        @Override
        public int first() {
            return ((IntegerSortedSet)this.wrapee).first();
        }

        @Override
        public IntegerSortedSet headSet(int v) {
            return IntegerCollections.unmodifiableSortedSet(((IntegerSortedSet)this.wrapee).headSet(v));
        }

        @Override
        public IntegerSortedSet subSet(int s, int e) {
            return IntegerCollections.unmodifiableSortedSet(((IntegerSortedSet)this.wrapee).subSet(s, e));
        }

        @Override
        public IntegerSortedSet tailSet(int v) {
            return IntegerCollections.unmodifiableSortedSet(((IntegerSortedSet)this.wrapee).tailSet(v));
        }

        @Override
        public int last() {
            return ((IntegerSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements IntegerSet {
        UnmodifiableSet(IntegerCollection s) {
            super(s);
        }

        @Override
        public IntegerSet collect(IntegerSet set) {
            return ((IntegerSet)this.wrapee).collect(set);
        }
    }

    private static class _Empty
    extends AbstractIntegerCollection {
        private _Empty() {
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(IntegerCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(Collection<? extends IntegerCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsInt(int v) {
            return false;
        }

        @Override
        public boolean containsAllInt(IntegerCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeInt(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllInt(IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntegerIterator intIterator() {
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements IntegerSortedSet {
        private _EmptyS() {
        }

        @Override
        public IntegerSet collect(IntegerSet set) {
            return this;
        }

        @Override
        public IntegerSortedSet collect(IntegerSortedSet set) {
            return this;
        }

        @Override
        public int first() {
            throw new NoSuchElementException();
        }

        @Override
        public IntegerSortedSet headSet(int v) {
            return this;
        }

        @Override
        public IntegerSortedSet subSet(int s, int e) {
            return this;
        }

        @Override
        public IntegerSortedSet tailSet(int v) {
            return this;
        }

        @Override
        public int last() {
            throw new NoSuchElementException();
        }
    }

    private static class _EmptyV
    extends AbstractIntegerVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Integer set(int index, Integer element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Integer element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addInt(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllInt(int index, IntegerCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getInt(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfInt(int v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public int removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntegerList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public IntegerList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public int setInt(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfInt(int v) {
            return -1;
        }

        @Override
        public IntegerVectorIterator intVectorIterator() {
            return IntegerIterators.NULL_ITERATOR;
        }

        @Override
        public IntegerVectorIterator intVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.intVectorIterator();
        }

        @Override
        public IntegerVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        private static class _Itr
        implements ListIterator<Integer> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Integer next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Integer previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Integer e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Integer e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

