/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.po.IntegerMap;

public abstract class AbstractIntegerMap<V>
implements IntegerMap<V> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient IntegerSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.intKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (IntegerMap.PrimitiveEntryK e : this.intKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(int k) {
        for (IntegerMap.PrimitiveEntryK e : this.intKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.intKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerMap<V> map) {
        for (IntegerMap.PrimitiveEntryK<V> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.intKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Integer) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        return this.putElement(key, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Integer) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> m) {
        for (Map.Entry<Integer, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Integer> keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        final Set e = this.intKeyEntrySet();
        return new AbstractSet<Map.Entry<Integer, V>>(){

            @Override
            public Iterator<Map.Entry<Integer, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Integer, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Integer, V> next() {
                        final IntegerMap.PrimitiveEntryK o = (IntegerMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Integer, V>(){

                            @Override
                            public Integer getKey() {
                                return o.getKey();
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerMap.PrimitiveEntryK e : this.intKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public V put(int k, V v) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public V removeElement(int k) {
        Iterator i = this.intKeyEntrySet().iterator();
        while (i.hasNext()) {
            IntegerMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerMap.PrimitiveEntryK e : this.intKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerMap)) break block1;
            m = (IntegerMap)obj;
            i = this.intKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerMap.PrimitiveEntryK e : this.intKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<IntegerMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((IntegerMap.PrimitiveEntryK)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractIntegerMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCollection<V> {
        private Set<IntegerMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<IntegerMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((IntegerMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerMap.this.size();
        }
    }
}

