/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.AbstractLongSet;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.CharacterValueMap;
import net.morilib.util.primitive.map.po.LongMap;
import net.morilib.util.primitive.map.pp.LongCharacterMap;

public abstract class AbstractLongCharacterMap
implements LongCharacterMap {
    private transient LongSet keySet = null;
    private transient CharacterCollection values = null;
    private transient Set<LongMap.PrimitiveEntryK<Character>> entrySetK = null;
    private transient Set<CharacterValueMap.PrimitiveEntryV<Long>> entrySetV = null;
    private transient Set<Map.Entry<Long, Character>> entrySet = null;

    @Override
    public void clear() {
        Iterator<LongCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(char v) {
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public char f(long k) {
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Character getElement(long k) {
        return Character.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet longKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(LongCharacterMap map) {
        for (LongCharacterMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Character) {
            return this.containsKeyElement((Long)key);
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        if (key instanceof Character) {
            return this.getElement((Long)key);
        }
        return null;
    }

    @Override
    public Character put(Long key, char value) {
        return this.putElement((long)key, value);
    }

    @Override
    public Character remove(Object key) {
        if (key instanceof Character) {
            return this.removeElement((Long)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Character> m) {
        for (Map.Entry<? extends Long, ? extends Character> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongSet keySet() {
        return this.longKeySet();
    }

    @Override
    public Set<Map.Entry<Long, Character>> entrySet() {
        final Set<LongCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Long, Character>>(){

                @Override
                public Iterator<Map.Entry<Long, Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Long, Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Long, Character> next() {
                            final LongCharacterMap.PrimitiveEntry o = (LongCharacterMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Long, Character>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(long k) {
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Character get(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.getElement((char)k);
    }

    @Override
    public Character put(int k, Character v) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.putElement((long)k, v);
    }

    @Override
    public Character removeElement(long k) {
        Iterator<LongCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            LongCharacterMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            char r = e.getValue();
            i.remove();
            return Character.valueOf(r);
        }
        return null;
    }

    @Override
    public Character remove(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<LongMap.PrimitiveEntryK<Character>> longKeyEntrySet() {
        final Set<LongCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<LongMap.PrimitiveEntryK<Character>>(){

                @Override
                public Iterator<LongMap.PrimitiveEntryK<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongMap.PrimitiveEntryK<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongMap.PrimitiveEntryK<Character> next() {
                            final LongCharacterMap.PrimitiveEntry o = (LongCharacterMap.PrimitiveEntry)i.next();
                            return new LongMap.PrimitiveEntryK<Character>(){

                                @Override
                                public long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Character putElement(long k, Character v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongMap<Character> map) {
        for (LongMap.PrimitiveEntryK<Character> e : map.longKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((char)v);
    }

    @Override
    public Set<CharacterValueMap.PrimitiveEntryV<Long>> charValueEntrySet() {
        final Set<LongCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<CharacterValueMap.PrimitiveEntryV<Long>>(){

                @Override
                public Iterator<CharacterValueMap.PrimitiveEntryV<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterValueMap.PrimitiveEntryV<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterValueMap.PrimitiveEntryV<Long> next() {
                            final LongCharacterMap.PrimitiveEntry o = (LongCharacterMap.PrimitiveEntry)i.next();
                            return new CharacterValueMap.PrimitiveEntryV<Long>(){

                                @Override
                                public Long getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public char getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public char setValue(char value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public char getElement(Object k) {
        if (k instanceof Long) {
            return this.f((Long)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public char putElement(Long k, char v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterValueMap<Long> map) {
        for (CharacterValueMap.PrimitiveEntryV<Long> e : map.charValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection charValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Character) {
            return this.containsValueElement(((Character)value).charValue());
        }
        return false;
    }

    @Override
    public Character put(Long key, Character value) {
        return this.putElement((long)key, value.charValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof LongCharacterMap)) break block1;
            m = (LongCharacterMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).charValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractLongSet {
        private Set<LongCharacterMap.PrimitiveEntry> eset;

        private KSet(Set<LongCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<LongCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public long next() {
                    return ((LongCharacterMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongCharacterMap.this.size();
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractLongCharacterMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongCharacterMap.this.clear();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCharacterCollection {
        private Set<LongCharacterMap.PrimitiveEntry> eset;

        private VCol(Set<LongCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<LongCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((LongCharacterMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractLongCharacterMap.this.size();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractLongCharacterMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLongCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractLongCharacterMap.this.clear();
        }
    }
}

