/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.arith;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NonnegativeDegree
extends Number
implements Comparable<NonnegativeDegree> {
    public static NonnegativeDegree ZERO = new NonnegativeDegree(0, true);
    private static Pattern PARSE = Pattern.compile("^([0-9]+\u00b0)?([0-9]+\u2032)?([0-9]+(\\.[0-9]+)?\u2033)?$");
    private static int SECOND_BIT_NUM = 8;
    private static int MINUTE_BIT_NUM = 14;
    private static int DEGREE_BIT_NUM = 20;
    private static int MAX_DEGREES = 2048;
    private static int MAX_SECONDS = 0x708000;
    private static int MAX_I = MAX_DEGREES * 60 * 60 * 100;
    private static int DECIMAL_PT = 100;
    private int value;

    NonnegativeDegree(int x, boolean d) {
        this.value = x;
    }

    public NonnegativeDegree(int x) {
        int r = x;
        if (r >= MAX_I) {
            throw new IllegalArgumentException();
        }
        if (r < 0) {
            throw new IllegalArgumentException();
        }
        this.value = x % 10;
        this.value |= (x /= 10) % 10 << 4;
        this.value |= (x /= 10) % 60 << SECOND_BIT_NUM;
        this.value |= (x /= 60) % 60 << MINUTE_BIT_NUM;
        this.value |= (x /= 60) << DEGREE_BIT_NUM;
    }

    public NonnegativeDegree(int degree, int minutes, int seconds, int undersec) {
        if (degree < 0 || degree >= MAX_DEGREES) {
            throw new IllegalArgumentException();
        }
        if (minutes < 0 || minutes >= 60) {
            throw new IllegalArgumentException();
        }
        if (seconds < 0 || seconds >= 60) {
            throw new IllegalArgumentException();
        }
        if (undersec < 0 || undersec >= 100) {
            throw new IllegalArgumentException();
        }
        this.value = undersec % 10;
        this.value |= undersec / 10 << 4;
        this.value |= seconds << SECOND_BIT_NUM;
        this.value |= minutes << MINUTE_BIT_NUM;
        this.value |= degree << DEGREE_BIT_NUM;
    }

    public NonnegativeDegree(double seconds) {
        double x = seconds;
        if (seconds < 0.0) {
            throw new IllegalArgumentException();
        }
        if (seconds >= (double)MAX_SECONDS) {
            throw new IllegalArgumentException();
        }
        int s = (int)x;
        x = (x - (double)s) * 100.0;
        int u = (int)x;
        int d = s / 3600;
        int m = (s %= 3600) / 60;
        this.value = u % 10;
        this.value |= u / 10 << 4;
        this.value |= (s %= 60) << SECOND_BIT_NUM;
        this.value |= m << MINUTE_BIT_NUM;
        this.value |= d << DEGREE_BIT_NUM;
    }

    private static boolean emp(String s) {
        return s == null || s.equals("");
    }

    public static NonnegativeDegree parse(String string) {
        int s;
        int u;
        Matcher e = PARSE.matcher(string);
        if (string.equals("") || !e.matches()) {
            throw new NumberFormatException("syntax error");
        }
        String z1 = e.group(1);
        int d = NonnegativeDegree.emp(z1) ? 0 : Integer.parseInt(z1.replaceFirst("\u00b0", ""));
        String z2 = e.group(2);
        int m = NonnegativeDegree.emp(z2) ? 0 : Integer.parseInt(z2.replaceFirst("\u2032", ""));
        String z3 = e.group(3);
        if (NonnegativeDegree.emp(z3)) {
            u = 0;
            s = 0;
        } else if ((z3 = z3.replaceFirst("\u2033", "")).matches("^[0-9]+$")) {
            s = Integer.parseInt(z3);
            u = 0;
        } else {
            z3 = String.valueOf(z3) + "0";
            String[] p = z3.split("\\.");
            s = Integer.parseInt(p[0]);
            u = Integer.parseInt(p[1].substring(0, 2));
        }
        try {
            return new NonnegativeDegree(d, m, s, u);
        }
        catch (IllegalArgumentException e1) {
            throw new NumberFormatException();
        }
    }

    public NonnegativeDegree add(NonnegativeDegree x, int[] carry) {
        int b;
        int a;
        int c = 0;
        int r = 0;
        int i = 0;
        while (i < SECOND_BIT_NUM) {
            a = (this.value & 15 << i) >> i;
            b = (x.value & 15 << i) >> i;
            c = a + b + c;
            r |= c % 10 << i;
            c /= 10;
            i += 4;
        }
        while (i < DEGREE_BIT_NUM) {
            a = (this.value & 63 << i) >> i;
            b = (x.value & 63 << i) >> i;
            c = a + b + c;
            r |= c % 60 << i;
            c /= 60;
            i += 6;
        }
        a = this.value >> DEGREE_BIT_NUM;
        b = x.value >> DEGREE_BIT_NUM;
        c = a + b + c;
        r |= c % MAX_DEGREES << DEGREE_BIT_NUM;
        c /= MAX_DEGREES;
        if (carry != null && carry.length > 0) {
            carry[0] = c;
        }
        return new NonnegativeDegree(r, true);
    }

    public NonnegativeDegree add(NonnegativeDegree x) {
        return this.add(x, null);
    }

    /*
     * Unable to fully structure code
     */
    public NonnegativeDegree subtract(NonnegativeDegree x) {
        c = 0;
        r = 0;
        i = 0;
        if (this.compareTo(x) >= 0) ** GOTO lbl15
        throw new ArithmeticException("the result is negative");
lbl-1000:
        // 1 sources

        {
            a = (this.value & 15 << i) >> i;
            b = (x.value & 15 << i) >> i;
            if ((c = a - b + c) < 0) {
                r |= c + 10 << i;
                c = -1;
            } else {
                r |= c << i;
                c = 0;
            }
            i += 4;
lbl15:
            // 2 sources

            ** while (i < NonnegativeDegree.SECOND_BIT_NUM)
        }
lbl16:
        // 2 sources

        while (i < NonnegativeDegree.DEGREE_BIT_NUM) {
            a = (this.value & 63 << i) >> i;
            b = (x.value & 63 << i) >> i;
            if ((c = a - b + c) < 0) {
                r |= c + 60 << i;
                c = -1;
            } else {
                r |= c << i;
                c = 0;
            }
            i += 6;
        }
        a = this.value >> NonnegativeDegree.DEGREE_BIT_NUM;
        b = x.value >> NonnegativeDegree.DEGREE_BIT_NUM;
        if ((c = a - b + c) < 0) {
            r |= c + NonnegativeDegree.MAX_DEGREES << i;
            c = -1;
        } else {
            r |= c << i;
            c = 0;
        }
        return new NonnegativeDegree(r, true);
    }

    public int toCentiSecond() {
        int r = this.value >> DEGREE_BIT_NUM;
        r = r * 60 + (this.value >> MINUTE_BIT_NUM & 0x3F);
        r = r * 60 + (this.value >> SECOND_BIT_NUM & 0x3F);
        r = r * 10 + (this.value >> 4 & 0xF);
        r = r * 10 + (this.value & 0xF);
        return r;
    }

    public NonnegativeDegree multiply(NonnegativeDegree x, int[] carry) {
        long a = this.toCentiSecond();
        long b = x.toCentiSecond();
        long c = a * b / (long)DECIMAL_PT;
        if (carry != null && carry.length > 0) {
            carry[0] = (int)(c / (long)MAX_I);
        }
        return new NonnegativeDegree((int)(c % (long)MAX_I));
    }

    public NonnegativeDegree multiply(NonnegativeDegree x) {
        return this.multiply(x, null);
    }

    public NonnegativeDegree divide(NonnegativeDegree x, int[] carry) {
        long a = this.toCentiSecond();
        long b = x.toCentiSecond();
        if (x.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        long c = a * (long)DECIMAL_PT / b;
        if (carry != null && carry.length > 0) {
            carry[0] = (int)(c / (long)MAX_I);
        }
        return new NonnegativeDegree((int)(c % (long)MAX_I));
    }

    public NonnegativeDegree divide(NonnegativeDegree x) {
        return this.divide(x, null);
    }

    public NonnegativeDegree invert() {
        long a = this.toCentiSecond();
        if (this.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        long c = (long)(DECIMAL_PT * DECIMAL_PT) / a;
        return new NonnegativeDegree((int)c);
    }

    public NonnegativeDegree remainder(NonnegativeDegree x) {
        long a = this.toCentiSecond();
        long b = x.toCentiSecond();
        if (x.signum() == 0) {
            throw new ArithmeticException("divide by zero");
        }
        long c = a % b;
        return new NonnegativeDegree((int)c);
    }

    public int signum() {
        return this.value > 0 ? 1 : 0;
    }

    @Override
    public int intValue() {
        return this.toCentiSecond() / DECIMAL_PT;
    }

    @Override
    public long longValue() {
        return this.toCentiSecond() / DECIMAL_PT;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        double r = 0.0;
        r = this.value >> DEGREE_BIT_NUM;
        r = r * 60.0 + (double)(this.value >> MINUTE_BIT_NUM & 0x3F);
        r = r * 60.0 + (double)(this.value >> SECOND_BIT_NUM & 0x3F);
        r += (double)(this.value >> 4 & 0xF) * 0.1;
        return r += (double)(this.value & 0xF) * 0.01;
    }

    @Override
    public int compareTo(NonnegativeDegree o) {
        return this.value < o.value ? -1 : (this.value > o.value ? 1 : 0);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof NonnegativeDegree) {
            return this.value == ((NonnegativeDegree)o).value;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int f = 0;
        b.append(this.value >> DEGREE_BIT_NUM).append("\u00b0");
        b.append(this.value >> MINUTE_BIT_NUM & 0x3F).append("\u2032");
        b.append(this.value >> SECOND_BIT_NUM & 0x3F);
        f = (this.value >> 4 & 0xF) * 10 + (this.value & 0xF);
        if (f != 0) {
            b.append(".").append(f).append("\u2033");
        } else {
            b.append("\u2033");
        }
        return b.toString();
    }
}

