/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.arith;

public class Signum2
implements Comparable<Signum2> {
    public static final Signum2 POSITIVE = new Signum2(true);
    public static final Signum2 NEGATIVE = new Signum2(false);
    private boolean signum;

    private Signum2(boolean signum) {
        this.signum = signum;
    }

    public static Signum2 toSignum(int x) {
        if (x == 0) {
            throw new IllegalArgumentException();
        }
        return x > 0 ? POSITIVE : NEGATIVE;
    }

    public static Signum2 toSignum(long x) {
        if (x == 0L) {
            throw new IllegalArgumentException();
        }
        return x > 0L ? POSITIVE : NEGATIVE;
    }

    public Signum2 multiply(Signum2 x) {
        return this.signum != x.signum ? NEGATIVE : POSITIVE;
    }

    public int signum() {
        return this.signum ? 1 : -1;
    }

    public long multiply(long x) {
        return this.signum ? x : -x;
    }

    public int multiply(int x) {
        return this.signum ? x : -x;
    }

    public double multiply(double x) {
        return this.signum ? x : -x;
    }

    public Signum2 negate() {
        return this.signum ? NEGATIVE : POSITIVE;
    }

    @Override
    public int compareTo(Signum2 o) {
        return this.signum == o.signum ? 0 : (this.signum && !o.signum ? 1 : -1);
    }

    public String toString() {
        return this.signum ? "+" : "-";
    }
}

