/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class NFAWrapper<T, A, B>
extends NFAObject<T, A, B> {
    protected NFAObject<T, A, B> wrapee;

    @Override
    void addStates(Set<NFAState> res, NFAState state, T alphabet) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStates(res, state, alphabet);
        }
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, Range a) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStates(res, state, a);
        }
    }

    @Override
    void addStatesBound(Set<NFAState> res, NFAState state, EnumSet<TextBound> a) {
        if (this.wrapee.isState(state)) {
            this.wrapee.addStatesBound(res, state, a);
        }
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        this.wrapee.addInitialStates(res);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        this.wrapee.addStatesEpsilon(res, state);
    }

    @Override
    public boolean isState(NFAState o) {
        if (o instanceof NFAObject.IntStateObject) {
            return this.wrapee.isState(o);
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.wrapee.isInitialState(o);
    }

    @Override
    public boolean isFinal(NFAState o) {
        return this.wrapee.isFinal(o);
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        return this.wrapee.nextAlphabets(state);
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return this.wrapee.getAcceptedStates();
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getMatchTag(state));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getMatchTagEnd(state));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getAccept(state));
        }
        return Collections.unmodifiableSet(res);
    }
}

