/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number.cut;

import net.morilib.lang.number.IEEE754Double;
import net.morilib.lang.number.cut.NumberSchnitt;

public final class DoubleSchnitt
implements NumberSchnitt<Double> {
    private double point;
    private int isupper;

    private DoubleSchnitt(double point, int isupper) {
        if (Double.isInfinite(point)) {
            throw new IllegalArgumentException("Infinity is not allowed");
        }
        if (Double.isNaN(point)) {
            throw new IllegalArgumentException("NaN is not allowed");
        }
        this.point = point;
        this.isupper = isupper;
    }

    public static DoubleSchnitt cutUpper(double point) {
        if (point <= Double.MIN_VALUE) {
            throw new IllegalArgumentException("cannot constract a cut");
        }
        return new DoubleSchnitt(point, 1);
    }

    public static DoubleSchnitt cutLower(double point) {
        if (point >= Double.MAX_VALUE) {
            throw new IllegalArgumentException("cannot constract a cut");
        }
        return new DoubleSchnitt(point, -1);
    }

    @Override
    public int belongs(Double t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(byte t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(short t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(int t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(long t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(float t) {
        return this.belongs((double)t);
    }

    @Override
    public int belongs(double t) {
        return t < this.point ? -1 : (t > this.point ? 1 : this.isupper);
    }

    @Override
    public Double gratestLowerBound() {
        return this.doubleGratestLowerBound();
    }

    @Override
    public Double leastUpperBound() {
        return this.doubleLeastLowerBound();
    }

    public double doubleGratestLowerBound() {
        return this.isupper < 0 ? this.point : IEEE754Double.inclement(this.point);
    }

    public double doubleLeastLowerBound() {
        return this.isupper > 0 ? this.point : IEEE754Double.declement(this.point);
    }
}

