/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.morilib.lang.composite.TraverseCollection;
import net.morilib.lang.proposition.LogicalAnd;
import net.morilib.lang.proposition.LogicalNot;
import net.morilib.lang.proposition.ManyVariableProposition;
import net.morilib.lang.proposition.Proposition;

public final class LogicalOr<S extends Proposition<S>>
implements Proposition<S> {
    @TraverseCollection(value=ArrayList.class)
    List<Proposition<S>> propositions;
    Proposition<S> negation;

    LogicalOr(List<Proposition<S>> propositions) {
        this.propositions = propositions;
    }

    LogicalOr(List<Proposition<S>> propositions, Proposition<S> negation) {
        this.propositions = propositions;
        this.negation = negation;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(List<Proposition<S>> propositions) {
        LogicalOr<S> res = new LogicalOr<S>(new ArrayList<Proposition<S>>());
        if (propositions == null) {
            throw new NullPointerException();
        }
        ArrayList q = new ArrayList(propositions.size());
        int i = 0;
        while (i < propositions.size()) {
            q.add(LogicalNot.newInstance(propositions.get(i)));
            ++i;
        }
        res.negation = new LogicalAnd(q, res);
        for (Proposition<S> p : propositions) {
            if (p == null) {
                throw new NullPointerException();
            }
            if (p.isTrue()) {
                return p;
            }
            if (p.isFalse()) continue;
            if (p instanceof LogicalOr) {
                LogicalAnd pp = (LogicalAnd)p;
                for (Proposition e : pp.propositions) {
                    if (res.implies(e)) continue;
                    res.propositions.add(e);
                }
                continue;
            }
            if (res.implies(p)) continue;
            res.propositions.add(p);
        }
        return res;
    }

    public static <S extends Proposition<S>> Proposition<S> newInstance(Proposition<?> ... propositions) {
        return LogicalOr.newInstance(Arrays.asList(propositions));
    }

    @Override
    public boolean is(Object ... variables) {
        for (Proposition<S> p : this.propositions) {
            if (!p.is(variables)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is1(Object var1) {
        for (Proposition<S> p : this.propositions) {
            if (!p.is(var1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is2(Object var1, Object var2) {
        for (Proposition<S> p : this.propositions) {
            if (!p.is(var1, var2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEqualTo(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (p instanceof LogicalOr) {
            return ManyVariableProposition.isEquivalent(this.propositions, ((LogicalAnd)p).propositions);
        }
        return false;
    }

    @Override
    public boolean implies(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return p.isIndependent(this.negation);
    }

    @Override
    public boolean isImplied(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        for (Proposition<S> e : this.propositions) {
            if (e.isImplied(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIndependent(Proposition<S> p) {
        if (p == null) {
            throw new NullPointerException();
        }
        for (Proposition<S> e : this.propositions) {
            if (e.isIndependent(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFalse() {
        return this.propositions.size() == 0;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String dlm = "";
        buf.append("(");
        for (Proposition<S> e : this.propositions) {
            buf.append(dlm);
            buf.append(e.toString());
            dlm = " or ";
        }
        buf.append(")");
        return buf.toString();
    }
}

