/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.proposition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.lang.proposition.LogicalNot;
import net.morilib.lang.proposition.OneVariableProposition;
import net.morilib.lang.proposition.Proposition;

public class SetContains
extends OneVariableProposition<SetContains> {
    public static final Proposition<SetContains> EMPTY = new SetContains(false, Collections.<Object>emptySet());
    public static final Proposition<SetContains> UNIVERSE = LogicalNot.newInstance(EMPTY);
    private Set<Object> elements;

    private SetContains(boolean dummy, Set<Object> elements) {
        this.elements = elements;
    }

    public static Proposition<SetContains> getEmpty() {
        return EMPTY;
    }

    public SetContains(Collection<Object> elements) {
        this.elements = new HashSet<Object>(elements);
    }

    public SetContains(Object ... ts) {
        this(Arrays.asList(ts));
    }

    @Override
    public boolean is1(Object var1) {
        return this.elements.contains(var1);
    }

    @Override
    public boolean implies(Proposition<SetContains> p) {
        if (p instanceof SetContains) {
            SetContains s = (SetContains)p;
            return this.elements.containsAll(s.elements);
        }
        return p.isImplied(this);
    }

    @Override
    public boolean isImplied(Proposition<SetContains> p) {
        if (p instanceof SetContains) {
            SetContains s = (SetContains)p;
            return s.elements.containsAll(this.elements);
        }
        return p.implies(this);
    }

    @Override
    public boolean isIndependent(Proposition<SetContains> p) {
        for (Object e : this.elements) {
            if (!p.is1(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqualTo(Proposition<SetContains> p) {
        if (p instanceof SetContains) {
            SetContains s = (SetContains)p;
            return this.elements.equals(s.elements);
        }
        return false;
    }

    @Override
    public boolean isFalse() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    public String toString() {
        return this.elements.toString();
    }
}

