/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class FrenchNumeral {
    private static String[] NUMERAL20 = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf"};
    private static String[] NUMERAL60 = new String[]{"", "", "vingt", "trente", "quarante", "cinquante", "soixante"};
    private static String[] NUMERAL1000 = new String[]{"", "mille", "million", "milliard", "billion", "billiard", "trillion", "trilliard", "quadrillion", "quadrilliard", "quintillion", "quintilliard", "sextillion", "sextilliard", "septillion", "septilliard", "octillion", "octilliard", "nonillion", "nonilliard", "d\u00e9cillion", "d\u00e9cilliard"};
    static final BigInteger MILLE = BigInteger.valueOf(1000L);
    static final BigInteger CENT = BigInteger.valueOf(100L);
    static final Map<String, BigInteger> DICTIONARY9 = FrenchNumeral.init9();
    static final Map<String, BigInteger> DICTIONARY99 = FrenchNumeral.init99();
    static final Map<String, BigInteger> DICTIONARY1000 = FrenchNumeral.init1000();

    private FrenchNumeral() {
    }

    static void putnum(Map<String, BigInteger> m, String s, int i) {
        m.put(s, BigInteger.valueOf(i));
    }

    static Map<String, BigInteger> init9() {
        HashMap<String, BigInteger> m = new HashMap<String, BigInteger>();
        int i = 1;
        while (i < 10) {
            FrenchNumeral.putnum(m, NUMERAL20[i], i);
            ++i;
        }
        return m;
    }

    static Map<String, BigInteger> init99() {
        Map<String, BigInteger> m = FrenchNumeral.init9();
        HashMap<String, BigInteger> n = new HashMap<String, BigInteger>();
        int i = 2;
        while (i < NUMERAL60.length) {
            FrenchNumeral.putnum(n, NUMERAL60[i], i * 10);
            ++i;
        }
        HashMap<String, BigInteger> r = new HashMap<String, BigInteger>();
        for (Map.Entry<String, BigInteger> em : m.entrySet()) {
            for (Map.Entry en : n.entrySet()) {
                if (em.getValue().equals(BigInteger.ONE)) continue;
                r.put(String.valueOf((String)en.getKey()) + "-" + em.getKey(), ((BigInteger)en.getValue()).add(em.getValue()));
            }
        }
        r.putAll(m);
        r.putAll(n);
        FrenchNumeral.putnum(r, "soixante-dix", 70);
        i = 12;
        while (i < 20) {
            FrenchNumeral.putnum(r, "soixante-" + NUMERAL20[i], i + 60);
            ++i;
        }
        FrenchNumeral.putnum(r, "quatre-vingts", 80);
        i = 1;
        while (i < 20) {
            FrenchNumeral.putnum(r, "quatre-vingt-" + NUMERAL20[i], i + 80);
            ++i;
        }
        i = 10;
        while (i < 20) {
            FrenchNumeral.putnum(r, NUMERAL20[i], i);
            ++i;
        }
        return r;
    }

    static Map<String, BigInteger> init1000() {
        BigInteger j = BigInteger.ONE;
        HashMap<String, BigInteger> m = new HashMap<String, BigInteger>();
        int i = 1;
        while (i < NUMERAL1000.length) {
            j = j.multiply(MILLE);
            m.put(NUMERAL1000[i], j);
            ++i;
        }
        return m;
    }

    static String describe100(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 20) {
            return NUMERAL20[n];
        }
        if (n < 70) {
            String s = NUMERAL60[n / 10];
            if (n % 10 == 0) {
                return s;
            }
            if (n % 10 == 1) {
                return String.valueOf(s) + " et un";
            }
            return String.valueOf(s) + "-" + NUMERAL20[n % 10];
        }
        if (n == 71) {
            return "soixante et onze";
        }
        if (n < 80) {
            return "soixante-" + NUMERAL20[n - 60];
        }
        if (n == 80) {
            return "quatre-vingts";
        }
        if (n < 100) {
            return "quatre-vingt-" + NUMERAL20[n - 80];
        }
        throw new RuntimeException();
    }

    static String describe1000(int n) {
        if (n < 100) {
            return FrenchNumeral.describe100(n);
        }
        if (n == 100) {
            return "cent";
        }
        if (n < 200) {
            return "cent " + FrenchNumeral.describe100(n % 100);
        }
        if (n % 100 == 0) {
            return String.valueOf(NUMERAL20[n / 100]) + " cents";
        }
        return String.valueOf(NUMERAL20[n / 100]) + " cent " + FrenchNumeral.describe100(n % 100);
    }

    public static String describeNumber(BigInteger n) {
        BigInteger[] b;
        StringBuffer r = new StringBuffer();
        BigInteger x = n;
        int[] ms = new int[NUMERAL1000.length];
        int i = 0;
        if (n.signum() < 0) {
            return null;
        }
        if (n.signum() == 0) {
            return "z\u00e9ro";
        }
        do {
            b = x.divideAndRemainder(MILLE);
            ms[i++] = b[1].intValue();
        } while ((x = b[0]).signum() != 0);
        int j = i - 1;
        while (j >= 0) {
            if (j >= NUMERAL1000.length) {
                return null;
            }
            if (j < i - 1) {
                r.append(" ");
            }
            if (j != 1 || ms[j] > 1) {
                r.append(FrenchNumeral.describe1000(ms[j]));
                if (j > 0) {
                    r.append(" ");
                }
            }
            if (j > 0) {
                r.append(NUMERAL1000[j]);
            }
            --j;
        }
        return r.toString();
    }

    public static String describeNumber(long n) {
        return FrenchNumeral.describeNumber(BigInteger.valueOf(n));
    }

    static BigInteger milleplural(String s) {
        if (s.charAt(s.length() - 1) == 's') {
            String x = s.substring(0, s.length() - 1);
            return DICTIONARY1000.get(x);
        }
        return null;
    }

    public static BigInteger parseNumber(String s) {
        BigInteger bf = null;
        BigInteger bi = null;
        BigInteger br = BigInteger.ZERO;
        int stat = 100;
        if (s == null) {
            throw new NullPointerException();
        }
        String[] sp = s.split("[ \t\n]+");
        if (sp.length == 0) {
            throw new NumberFormatException();
        }
        if (s.equals("z\u00e9ro")) {
            return BigInteger.ZERO;
        }
        int i = 0;
        while (true) {
            switch (stat) {
                case 100: {
                    if (i == sp.length) {
                        return br;
                    }
                    bi = DICTIONARY9.get(sp[i]);
                    if (bi != null) {
                        stat = 111;
                        break;
                    }
                    bi = DICTIONARY99.get(sp[i]);
                    if (bi != null) {
                        stat = 113;
                        break;
                    }
                    if (sp[i].equals("cent")) {
                        bi = CENT;
                        stat = 121;
                        break;
                    }
                    if (sp[i].equals("mille")) {
                        br = br.add(MILLE);
                        bf = MILLE;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 111: {
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    if (sp[i].equals("cents")) {
                        if (bi.equals(BigInteger.ONE)) {
                            throw new NumberFormatException();
                        }
                        bi = bi.multiply(CENT);
                        stat = 131;
                        break;
                    }
                    if (sp[i].equals("cent")) {
                        bi = bi.multiply(CENT);
                        stat = 121;
                        break;
                    }
                    if (sp[i].equals("et")) {
                        switch (bi.intValue()) {
                            case 20: 
                            case 30: 
                            case 40: 
                            case 50: 
                            case 60: {
                                break;
                            }
                            default: {
                                throw new NumberFormatException();
                            }
                        }
                        stat = 112;
                        break;
                    }
                    --i;
                    stat = 131;
                    break;
                }
                case 112: {
                    if (i == sp.length) {
                        throw new NumberFormatException();
                    }
                    if (sp[i].equals("un")) {
                        bi = bi.add(BigInteger.ONE);
                        stat = 131;
                        break;
                    }
                    if (sp[i].equals("onze") && bi.intValue() == 60) {
                        bi = bi.add(BigInteger.valueOf(11L));
                        stat = 131;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 113: {
                    if (i == sp.length) {
                        --i;
                        stat = 131;
                        break;
                    }
                    if (sp[i].equals("et")) {
                        switch (bi.intValue()) {
                            case 20: 
                            case 30: 
                            case 40: 
                            case 50: 
                            case 60: {
                                break;
                            }
                            default: {
                                throw new NumberFormatException();
                            }
                        }
                        stat = 112;
                        break;
                    }
                    --i;
                    stat = 131;
                    break;
                }
                case 121: {
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    BigInteger bj = DICTIONARY99.get(sp[i]);
                    if (bj != null) {
                        bi = bi.add(bj);
                        stat = 131;
                        break;
                    }
                    bj = DICTIONARY1000.get(sp[i]);
                    if (bj != null) {
                        if (bf != null && bf.compareTo(bj) <= 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    throw new NumberFormatException();
                }
                case 131: {
                    BigInteger bj;
                    if (i == sp.length) {
                        return br.add(bi);
                    }
                    if (bi.intValue() == 1 && (bj = DICTIONARY1000.get(sp[i])) != null) {
                        if (bf != null && bf.compareTo(bj) <= 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    if (sp[i].equals("mille")) {
                        if (bf != null && bf.compareTo(MILLE) <= 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(MILLE));
                        bf = MILLE;
                        stat = 100;
                        break;
                    }
                    if (bi.intValue() > 1 && (bj = FrenchNumeral.milleplural(sp[i])) != null) {
                        if (bf != null && bf.compareTo(bj) <= 0) {
                            throw new NumberFormatException();
                        }
                        br = br.add(bi.multiply(bj));
                        bf = bj;
                        stat = 100;
                        break;
                    }
                    throw new NumberFormatException();
                }
            }
            ++i;
        }
    }
}

