/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.plural;

import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import net.morilib.lingua.plural.PluralConverter;
import net.morilib.lingua.plural.UnsupportedLocaleException;

public final class SimplePluralConverter {
    private static final String LOCATION = "net.morilib.lingua.plural.SimplePluralConverter";
    private static Map<Locale, PluralConverter> pool = new WeakHashMap<Locale, PluralConverter>();
    public static final PluralConverter ENGLISH = SimplePluralConverter.getInstance(Locale.ENGLISH);

    private SimplePluralConverter() {
    }

    private static PluralConverter load(String name) throws ClassNotFoundException {
        PluralConverter res;
        try {
            Class<?> cl = Class.forName(name);
            res = (PluralConverter)cl.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedLocaleException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedLocaleException(e);
        }
        return res;
    }

    private static PluralConverter loadInstance(String cn, Locale lc) {
        try {
            return SimplePluralConverter.load(String.valueOf(cn) + "_" + lc.getLanguage() + "_" + lc.getCountry() + "_" + lc.getVariant());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return SimplePluralConverter.load(String.valueOf(cn) + "_" + lc.getLanguage() + "_" + lc.getCountry());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    return SimplePluralConverter.load(String.valueOf(cn) + "_" + lc.getLanguage());
                }
                catch (ClassNotFoundException e) {
                    throw new UnsupportedLocaleException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluralConverter getInstance(Locale lc) {
        PluralConverter res = pool.get(lc);
        if (res != null) return res;
        Class<SimplePluralConverter> clazz = SimplePluralConverter.class;
        synchronized (SimplePluralConverter.class) {
            res = SimplePluralConverter.loadInstance(LOCATION, lc);
            pool.put(lc, res);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }
}

