/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.logging.Logger;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispLazySubrSyn;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.Syntax;
import net.morilib.util.io.CharUnreadBuffer;

final class IntLispUtils {
    static boolean loadEager = false;

    private IntLispUtils() {
    }

    static Datum car(Datum d, LispMessage mesg) {
        if (d instanceof Cons) {
            return ((Cons)d).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cdr(Datum d, LispMessage mesg) {
        if (d instanceof Cons) {
            return ((Cons)d).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum caar(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCar()) instanceof Cons) {
            return ((Cons)c0).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cdar(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCar()) instanceof Cons) {
            return ((Cons)c0).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cadr(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCdr()) instanceof Cons) {
            return ((Cons)c0).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cddr(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCdr()) instanceof Cons) {
            return ((Cons)c0).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cadadr(Datum d, LispMessage mesg) {
        Datum e = d;
        if (!(e instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        return ((Cons)e).getCar();
    }

    static Datum cadaddr(Datum d, LispMessage mesg) {
        Datum e = d;
        if (!(e instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        return ((Cons)e).getCar();
    }

    static Datum caddaaddr(Datum d, LispMessage mesg) {
        Datum e = d;
        if (!(e instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            throw mesg.getError("err.require.pair");
        }
        return ((Cons)e).getCar();
    }

    static void bindLocal(Datum prms, Datum bcdr, Environment env, LispMessage mesg) {
        block7: {
            while (true) {
                if (prms == Nil.NIL) {
                    if (bcdr != Nil.NIL) {
                        throw mesg.getError("err.parameter.insufficient");
                    }
                    break block7;
                }
                if (prms instanceof Atom) {
                    if (!(prms instanceof Symbol)) {
                        throw mesg.getError("err.symbol", prms);
                    }
                    env.bindDatum(prms, bcdr);
                    break block7;
                }
                if (!(bcdr instanceof Cons)) {
                    throw mesg.getError("err.parameter.insufficient");
                }
                if (!(prms instanceof Cons)) break;
                Datum a1 = ((Cons)prms).getCar();
                Datum a2 = ((Cons)bcdr).getCar();
                if (!(a1 instanceof SymbolName)) {
                    throw mesg.getError("err.symbol", a1);
                }
                env.bindDatum(a1, a2);
                prms = ((Cons)prms).getCdr();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw mesg.getError("err.type.insufficient");
        }
    }

    static Datum findListEqv(Datum k, Datum lst, LispMessage mesg) {
        Datum d = lst;
        while (d != Nil.NIL) {
            if (lst instanceof Cons) {
                Cons c1 = (Cons)d;
                if (c1.getCar() instanceof Symbol) {
                    Symbol s = (Symbol)c1.getCar();
                    Symbol r = s.getEnclosedSymbol();
                    if (r == null && k == s) {
                        return k;
                    }
                    if (k == r) {
                        return k;
                    }
                } else if (k.isEqv(c1.getCar())) {
                    return k;
                }
                d = c1.getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return LispBoolean.FALSE;
    }

    static boolean isSymbolName(Datum d) {
        return d instanceof SymbolName;
    }

    static void timelog(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.fine(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void timelogFiner(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.finer(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void loadJavaSubr(Environment env, Symbol k, String v) {
        if (loadEager) {
            env.bindDatum(k, IntLispUtils.getJavaSubr(k, v));
        } else {
            env.bindDatum(k, new LispLazySubrSyn(env, k, v));
        }
    }

    static Datum getJavaSubr(Symbol k, String v) {
        try {
            Class<?> cls = Class.forName(v);
            Datum ins = (Datum)cls.newInstance();
            if (ins instanceof Subr) {
                ((Subr)ins).symbolName = k.getName();
            } else if (ins instanceof Syntax) {
                ((Syntax)ins).symbolName = k.getName();
            }
            return ins;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void loadJavaSubr(Environment env, Symbol k, String v, ClassLoader loader) {
        env.bindDatum(k, IntLispUtils.getJavaSubr(k, v, loader));
    }

    static Datum getJavaSubr(Symbol k, String v, ClassLoader loader) {
        try {
            Class<?> cls = loader.loadClass(v);
            Datum ins = (Datum)cls.newInstance();
            if (ins instanceof Subr) {
                ((Subr)ins).symbolName = k.getName();
            } else if (ins instanceof Syntax) {
                ((Syntax)ins).symbolName = k.getName();
            }
            return ins;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean skipShebang(Reader pb, CharUnreadBuffer ub) throws IOException {
        int st = 0;
        block4: while (true) {
            int c;
            if ((c = pb.read()) < 0) {
                return false;
            }
            switch (st) {
                case 0: {
                    if (c != 35) {
                        ub.unread((char)c);
                        return true;
                    }
                    st = 1;
                    continue block4;
                }
                case 1: {
                    if (c != 33) {
                        ub.unread('#');
                        ub.unread((char)c);
                        return true;
                    }
                    st = 2;
                    continue block4;
                }
            }
            if (c == 10) break;
        }
        return true;
    }

    static boolean skipShebang(PushbackReader pb) throws IOException {
        int st = 0;
        block4: while (true) {
            int c;
            if ((c = pb.read()) < 0) {
                return false;
            }
            switch (st) {
                case 0: {
                    if (c != 35) {
                        pb.unread((char)c);
                        return true;
                    }
                    st = 1;
                    continue block4;
                }
                case 1: {
                    if (c != 33) {
                        pb.unread(35);
                        pb.unread((char)c);
                        return true;
                    }
                    st = 2;
                    continue block4;
                }
            }
            if (c == 10) break;
        }
        return true;
    }
}

