/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaUtils;
import net.morilib.lisp.LispJavaUtils;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.ParameterNotFoundException;

class JavaClass
extends Datum {
    private Class<?> klass;

    JavaClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException();
        }
        this.klass = Class.forName(name);
    }

    Class<?> getJavaClass() {
        return this.klass;
    }

    JavaInstance newJavaInstance(List<Datum> lst) throws ParameterNotFoundException {
        return new JavaInstance(LispJavaUtils.newInstance(this.klass, lst));
    }

    Datum invokeMethod(String name, List<Datum> lst) throws ParameterNotFoundException {
        Object res = JavaUtils.invokeMethod(this.klass, null, name, lst);
        return LispUtils.toDatum(res);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<java-class>");
    }
}

