/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IntrospectionException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.JavaUtils;
import net.morilib.lisp.LispJavaUtils;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.ParameterNotFoundException;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.sos.ISlotDatum;

public class JavaInstance
extends Datum
implements JavaObjective,
ISlotDatum {
    private Object instance;

    JavaInstance(Object instance) {
        this.instance = instance;
    }

    Object getJavaInstance() {
        return this.instance;
    }

    Datum invokeMethod(String name, List<Datum> lst) throws ParameterNotFoundException {
        Object res = JavaUtils.invokeMethod(this.instance.getClass(), this.instance, name, lst);
        return LispUtils.toDatum(res);
    }

    Datum invokeGetter(String name) throws IntrospectionException, ParameterNotFoundException {
        Object res = JavaUtils.invokeGetter(this.instance, name);
        return LispUtils.toDatum(res);
    }

    void invokeSetter(String name, Datum d) throws IntrospectionException, ParameterNotFoundException {
        JavaUtils.invokeSetter(this.instance, name, d);
    }

    Datum invokeGetter(String name, int index) throws IntrospectionException, ParameterNotFoundException {
        Object res = JavaUtils.invokeGetter(this.instance, name, index);
        return LispUtils.toDatum(res);
    }

    void invokeSetter(String name, int index, Datum d) throws IntrospectionException, ParameterNotFoundException {
        JavaUtils.invokeSetter(this.instance, name, index, d);
    }

    @Override
    public Object toObject() {
        return this.instance;
    }

    @Override
    public Datum getSlot(Symbol sym) {
        try {
            return LispJavaUtils.newInstance(JavaUtils.invokeGetter(this.instance, sym.getName()));
        }
        catch (IntrospectionException e) {
            return null;
        }
        catch (ParameterNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        try {
            JavaUtils.invokeSetter(this.instance, sym.getName(), val);
            return true;
        }
        catch (IntrospectionException e) {
            return false;
        }
        catch (ParameterNotFoundException e) {
            return false;
        }
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        Object o = this.getJavaInstance();
        buf.append("#<java-instance ");
        buf.append(o.getClass().getName());
        buf.append(">");
    }
}

